/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonDef.h,v 1.6 2005/02/16 22:21:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

//==============================================================================
// CommonDef.h
//
// Some common definitions. Among other things, this file serves
// as a portability header. It should be included first in all sources 
// files (and probably most of the headers!). In particular, it is
// crucial that you include it before using any platform-specific
// conditionals, such as _WINDOWS_ or _UNIX_.
//
//==============================================================================

//??? NameSpace ???

#ifndef _COMMONDEF_H
#define _COMMONDEF_H

///////
// Required platform-specific includes 
///////
#if defined(WIN32) || defined(WIN64)
    // This brings _WINDOWS_ into scope. Use _WINDOWS_ to wrap Windows code.
#   include <windows.h>           /* for lots o' stuff, but esp. _WINDOWS_ */
#   include <malloc.h>            /* for alloca */
#elif defined(_UNIX_)
#  include <sys/param.h>          /* For MAXPATHLEN */
#  include <alloca.h>             /* for alloca */
#endif

//------------------------------------------------------------------------------
#define STR		char*
#define CSTR	const char*

typedef unsigned char BYTE, *PBYTE;
typedef unsigned short WORD, *PWORD;

#define SIZE_OF(x) sizeof(x)/sizeof(*x)

#define FOR_EACH(__iter) for(iterator __iter = begin(); __iter < end(); __iter++)

#if !defined(_WINDOWS_)
#	define _EXT_REF
#else
// Windows specific staff
#	ifdef  _DLL_EXPORT
#		define _EXT_REF	__declspec(dllexport) 
#	elif defined _DLL_IMPORT
#		define _EXT_REF	__declspec(dllimport) 
#	elif  defined _LIB
#		define _EXT_REF
#	else
#		define _EXT_REF
#	endif

typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;

#endif

//------------------------------------------------------------------------------
/////
// Windows-isms that pervade the code
/////
#if !defined(_WINDOWS_)
  typedef long long __int64;
  typedef long long int64_t;
  typedef unsigned long long uint64_t;
  typedef unsigned long       DWORD;
  typedef int                 BOOL;

#  ifndef CONST
#    define CONST               const
#  endif

#  ifndef FALSE
#    define FALSE               0
#  endif

#  ifndef TRUE
#    define TRUE                1
#  endif

#  ifndef LONG
#    define LONG                long
#  endif

  typedef char CHAR;
  typedef CHAR *PCHAR;
  typedef CHAR *LPCH, *PCH;

  typedef CONST CHAR *LPCCH, *PCCH;
  typedef CHAR *NPSTR;
  typedef CHAR *LPSTR, *PSTR;
  typedef CONST CHAR *LPCSTR, *PCSTR;

  //
  // Neutral ANSI/UNICODE types and macros
  //
#  ifdef  UNICODE                     // r_winnt

#    ifndef _TCHAR_DEFINED
       typedef WCHAR TCHAR, *PTCHAR;
       typedef WCHAR TBYTE , *PTBYTE ;
#      define _TCHAR_DEFINED
#    endif /* !_TCHAR_DEFINED */

    typedef LPWSTR LPTCH, PTCH;
    typedef LPWSTR PTSTR, LPTSTR;
    typedef LPCWSTR LPCTSTR;
    typedef LPWSTR LP;
#   define __TEXT(quote) L##quote      // r_winnt

#  else   /* UNICODE */               // r_winnt

#    ifndef _TCHAR_DEFINED
       typedef char TCHAR, *PTCHAR;
       typedef unsigned char TBYTE , *PTBYTE ;
#      define _TCHAR_DEFINED
#    endif /* !_TCHAR_DEFINED */

     typedef LPSTR LPTCH, PTCH;
     typedef LPSTR PTSTR, LPTSTR;
     typedef LPCSTR LPCTSTR;
#    define __TEXT(quote) quote         // r_winnt
#  endif /* UNICODE */                // r_winnt

   typedef void * HMODULE;

#  define APIENTRY
#endif // not Windows

//------------------------------------------------------------------------------
///////
// Specify endian-ness for your platform.
///////
#if defined(WIN32) || defined(IA32_ARCH) || defined(ALPHA_ARCH)
#   define BIG_ENDIAN_HW
#elif defined(SPARC_ARCH) || defined(HPPA_ARCH)
#   define LITTLE_ENDIAN_HW
#else
#   error "Platform-specific configuration required"
#endif

/////
// Byte swapping inline code to deal with endianess.
/////
typedef union
{
	unsigned char uc[4];
	unsigned int  ui;
} uc4_t;
// SwapBytes
// Convert buffer to little/big endian format
inline static void SwapBytes(void* i_pBuffer, long i_Size)
{
	uc4_t u;
	long c = 0;	// counter 

	unsigned char* ptr;

	while(c < i_Size - 2)
	{
		ptr = (BYTE*)i_pBuffer + c;
		u.ui = *(unsigned*)(ptr);

		for(int i = 0; i < 4; i++)
		{
			ptr[i] = u.uc[3-i];
		}
		c +=4;
	}
	if(i_Size - c >= 2)
	{
		ptr = (BYTE*)i_pBuffer + c;

		u.ui = *(unsigned short*)ptr;
		ptr[0] = u.uc[1];
		ptr[1] = u.uc[0];
	}
}

inline unsigned short LE_WORD(unsigned short i_word)
{
#ifdef BIG_ENDIAN_HW
	SwapBytes((void*)&i_word, sizeof(i_word));
#endif
	return i_word;
}

inline unsigned LE_DWORD(unsigned i_dword)
{
#ifdef BIG_ENDIAN_HW
	SwapBytes((void*)&i_dword, sizeof(i_dword));
#endif
	return i_dword;
}

inline int64_t LE_QWORD(int64_t i_qword)
{
#ifdef BIG_ENDIAN_HW
	SwapBytes((void*)&i_qword, sizeof(i_qword));
#endif
	return i_qword;
}

//------------------------------------------------------------------------------
/* On UNIX, use macros instead of calling memcpy as this is faster. 
 * On Windows, use regular memcpy() as this inlined.
 */
#ifdef _WINDOWS_
#  define MEMCPY2(x, y) memcpy(x, y, 2) 
#  define MEMCPY4(x, y) memcpy(x, y, 4) 
#elif defined(_UNIX_)  
#  define MEMCPY2(x, y) \
        { \
	    char *_tx = (char *)(x); \
	    char *_ty = (char *)(y); \
	    (*_tx) = (*_ty); \
	    *(_tx + 1) = *(_ty + 1); \
	}

#  define MEMCPY4(x, y) \
        { \
	    char *_tx = (char *)(x); \
	    char *_ty = (char *)(y); \
	    (*_tx) = (*_ty); \
	    *(_tx + 1) = *(_ty + 1); \
	    *(_tx + 2) = *(_ty + 2); \
	    *(_tx + 3) = *(_ty + 3); \
	}
#else
#  error "Platform-specific configuration required"
   // Pick the method most effective for your platform.
#endif 

/////
// Does your platform have stricmp or strcasecmp?
/////
#include <string.h>
#ifdef _UNIX_
#  define stricmp strcasecmp
#elif defined(_WINDOWS_)
   // stricmp comes from string.h
#else
#  error "Platform-specific configuration required"
#endif

/////
// How do you get the last error num?
/////
#ifdef _WINDOWS_
#  define LAST_ERROR GetLastError()
#elif defined(_UNIX_)
#  include <errno.h>
#  define LAST_ERROR errno
#else
#  error "Platform-specific configuration required"
#endif

/////
// Does your compiler support namespaces? Most should by now, so the
// default is to assume namespace support. If your compiler does not,
// define NO_NAMESPACES on the compiler command line. Usage:
//      USE_NAMESPACE(std);
/////
#ifdef NO_NAMESPACES
#  define USE_NAMESPACE(x)
#else
#  define USE_NAMESPACE(x) using namespace x
#endif // NO_NAMESPACES

#endif // defined _COMMONDEF_H

//==============================================================================
