/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CopyToClipboardAction.java,v 1.3 2005/02/16 22:20:27 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CopyToClipboardAction  implements IObjectActionDelegate {

	private CBECommonBaseEvent cbeEvents[];	
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	public void run()
	{
		if (cbeEvents != null)
		{
			StringBuffer strToCopy = new StringBuffer();
			
			for (int i = 0; i < (cbeEvents.length - 1); i++)
			{
				strToCopy.append(cbeEvents[i].getMsg());
				strToCopy.append(System.getProperty("line.separator"));
			}
			
			if (cbeEvents.length > 0)
				strToCopy.append(cbeEvents[cbeEvents.length-1].getMsg());
			
			if (strToCopy.length() > 0)
			{
				Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
				StringSelection ss = new StringSelection(strToCopy.toString());
				clipboard.setContents(ss, ss);
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		run();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection != null && selection instanceof IStructuredSelection)
		{
			Vector cbeEventsV = new Vector();
			
			Iterator iter = ((IStructuredSelection)selection).iterator();
		
			while (iter.hasNext())
			{
				Object obj = iter.next();
				
				if (obj instanceof CBECommonBaseEvent)
					cbeEventsV.addElement(obj);
			}
			
			
			cbeEvents = new CBECommonBaseEvent[cbeEventsV.size()];
			
			for (int i = 0; i < cbeEvents.length; i++)
			{
				cbeEvents[i] = (CBECommonBaseEvent)cbeEventsV.elementAt(i);
			}
		}
		else
		{
			cbeEvents = new CBECommonBaseEvent[0];
		}		
	}
}
