/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogLabelProvider.java,v 1.12 2005/03/19 00:47:48 curtispd Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * @author marcelop
 * @since 1.1.0
 */
public class LogLabelProvider 
extends LabelProvider
{
	private ILabelProvider pdLabelProvider;
	
	public LogLabelProvider()
	{
		pdLabelProvider = new SimpleLayout(null).getLabelProvider();		
	}
	
	/**
	 * @see org.eclipse.jface.viewers.LabelProvider#dispose()
	 */
	public void dispose()
	{
		pdLabelProvider.dispose();
		super.dispose();
	}

	
	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element)
	{
		if(element instanceof LogicalFolder)
			return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER);
		
		if(element instanceof TRCAgentProxy)
		{
			if(((TRCAgentProxy)element).isActive())
				return LogUIPluginImages.getImage(LogUIPluginImages.IMG_LOG_LIVE);	
			else
				return LogUIPluginImages.getImage(LogUIPluginImages.IMG_LOG_DEFAULT);
		}
			
			
		if(element instanceof CorrelationContainerProxy){
			return LogUIPluginImages.getImage(LogUIPluginImages.IMG_CORR_NAV);
		}
		
		if(element instanceof IResource)
		{
			IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IResource)element).getAdapter(IWorkbenchAdapter.class);
			if(workbenchAdapter != null)
				return workbenchAdapter.getImageDescriptor(element).createImage();
		}
		
		if(element instanceof TRCNode){
			return pdLabelProvider.getImage(element);
		}
		
		if(element instanceof INavigatorItem) {
			return ((INavigatorItem)element).getImage();
		}

		return null;
	}

	/**
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element)
	{
		if(element instanceof LogicalFolder)
			return ((LogicalFolder)element).getName();

		if(element instanceof TRCAgentProxy)
		{
			TRCAgentProxy agentProxy = (TRCAgentProxy)element;
			String file = agentProxy.getProfileFile();
			if(file == null || file=="")
				file = agentProxy.getName();
			if(file == null || file=="")
				return pdLabelProvider.getText(agentProxy);
				
			if((agentProxy.getProcessProxy() != null) && (agentProxy.getProcessProxy().getNode() != null))
			{
				String node = agentProxy.getProcessProxy().getNode().getName();
				if(node != null) {
					String label = LogUIPlugin.getResourceString("LOG_NAV_LOGLBLFMT", new String[]{node, file});
					if(((TRCAgentProxy)element).isActive()) {
						label = "<"+LogUIPlugin.getResourceString("STR_LIVE_LOG")+"> "+label;
					}
					return label;
				}
			}else{
				return "<removed>";
			}
			
			return file;			
		}
		
		if(element instanceof CorrelationContainerProxy){
			return ((CorrelationContainerProxy)element).getName();
		}
				
		if(element instanceof IFile)
			return ((IFile)element).getFullPath().toString();

		if(element instanceof IResource)
		{
			IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IResource)element).getAdapter(IWorkbenchAdapter.class);
			if(workbenchAdapter != null)
				return workbenchAdapter.getLabel(element);
		}
		
		if(element instanceof TRCNode){		
			return ((TRCNode)element).getName();
		}
		
		if(element instanceof INavigatorItem) {
			return ((INavigatorItem)element).getText();
		}
		
		return "";
	}
}
