/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogAnalyzerFilterPrefPage.java,v 1.11 2005/03/17 19:17:23 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.log.ui.internal.util.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFilterPrefPage{

	private boolean sevHasChanged = false;
	public CBEFilterUI _options;
	private IPreferenceStore _preferenceStore;
	
	public LogAnalyzerFilterPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		GridData data = GridUtil.createFill();
		composite.setLayoutData(data);

		_options = new CBEFilterUI(LogUIPlugin.getDefault().getPreferenceStore());
		_options.createControl(composite);

		initializeValues();
		WorkbenchHelp.setHelp(composite, ContextIds.ACTLOG_PREF_FILTER_PROPERTIES);

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return LogUIPlugin.getDefault().getPreferenceStore();
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		_options.initializeValues(true);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();

		_options.initializeValues(false);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		if(!_options.validate()){
			return false;
		}
		storeValues();
		LogUIPlugin.getDefault().savePluginPreferences();		
		if(_options.hasFilterChanged()){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_COL_CHANGE, this));
		}
		return true;
	}

	public boolean performApply(){

		if(!_options.validate()){
			return false;
		}
		storeValues();
		LogUIPlugin.getDefault().savePluginPreferences();		
		if(_options.hasFilterChanged()){			
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_COL_CHANGE, this));
		}
		return true;
	
	}
	
//	public boolean hasSevFilterChanged(){
//		return _options.hasSeverityFilterChanged();
//	}
	
	
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private boolean storeValues() {
		return _options.storeValues();
	}
}