/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogAnalyzerFormatPrefPage.java,v 1.9 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import java.text.DateFormat;
import java.util.Date;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFormatPrefPage {

	private Combo dateFormatCombo;
	private Combo timeFormatCombo;
	private IPreferenceStore _preferenceStore;

	public LogAnalyzerFormatPrefPage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridUtil.createHorizontalFill());

		Label description = new Label(composite, SWT.NONE);
		description.setText(
			LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DESCRIPTION"));

		Composite comboComposite = createComboGroup(composite);
		createFormatComboBoxes(comboComposite);

		return composite;
	}
	private Composite createComboGroup(Composite composite) {
		GridLayout layout = new GridLayout();
		layout.horizontalSpacing = 20;
		layout.verticalSpacing = 10;
		layout.numColumns = 2;

		Composite comboComposite = new Composite(composite, SWT.LEFT);
		comboComposite.setLayout(layout);
		comboComposite.setLayoutData(GridUtil.createHorizontalFill());
		return comboComposite;
	}
	private void createFormatComboBoxes(Composite composite) {
		// Create date format combo box.
		Label dateFormatLabel = new Label(composite, SWT.NONE);
		dateFormatLabel.setText(
			LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DATE_FORMAT_LABEL"));
		dateFormatCombo = new Combo(composite, SWT.READ_ONLY);
		dateFormatCombo.setItems(createDateFormatList());
		dateFormatCombo.setLayoutData(GridUtil.createHorizontalFill());
		
		// Create time format combo box.
		Label timeFormatLabel = new Label(composite, SWT.NONE);
		timeFormatLabel.setText(
			LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_TIME_FORMAT_LABEL"));
		timeFormatCombo = new Combo(composite, SWT.READ_ONLY);
		timeFormatCombo.setItems(createTimeFormatList());
		timeFormatCombo.setLayoutData(GridUtil.createHorizontalFill());

		selectFormatComboBoxes(
			_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE),
			_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME)
		);

		WorkbenchHelp.setHelp(dateFormatCombo, ContextIds.ACTLOG_PREF_FORMAT_DATE);
		WorkbenchHelp.setHelp(timeFormatCombo, ContextIds.ACTLOG_PREF_FORMAT_TIME);
	}
	
	private String[] createDateFormatList () {
		Date currentDate = new Date(System.currentTimeMillis());
		String[] dateFormatList = {
				LogUIConstants.DATE_FORMAT_FULL + " (" + (DateFormat.getDateInstance(DateFormat.FULL)).format(currentDate) + ")",
				LogUIConstants.DATE_FORMAT_LONG + " (" + (DateFormat.getDateInstance(DateFormat.LONG)).format(currentDate) + ")",
				LogUIConstants.DATE_FORMAT_MEDIUM + " (" + (DateFormat.getDateInstance(DateFormat.MEDIUM)).format(currentDate) + ")",
				LogUIConstants.DATE_FORMAT_SHORT + " (" + (DateFormat.getDateInstance(DateFormat.SHORT)).format(currentDate) + ")"
		};
		return dateFormatList;
	}
	
	private String[] createTimeFormatList () {
		Date currentDate = new Date(System.currentTimeMillis());
		String[] timeFormatList = {
				LogUIConstants.TIME_FORMAT_FULL + " (" + (DateFormat.getTimeInstance(DateFormat.FULL)).format(currentDate) + ")",
				LogUIConstants.TIME_FORMAT_LONG + " (" + (DateFormat.getTimeInstance(DateFormat.LONG)).format(currentDate) + ")",
				LogUIConstants.TIME_FORMAT_MEDIUM + " (" + (DateFormat.getTimeInstance(DateFormat.MEDIUM)).format(currentDate) + ")",
				LogUIConstants.TIME_FORMAT_SHORT + " (" + (DateFormat.getTimeInstance(DateFormat.SHORT)).format(currentDate) + ")"
		};
		return timeFormatList;
	}
	
	private void selectFormatComboBoxes (String dateFormat, String timeFormat) {
		// Set selection for date format combo box.
		int index =-1;
		for (int i = 0; i < LogUIConstants.DATE_FORMAT_LIST.length; i++) {
			if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
				index = i;
				break;
			}
		}
		if (index>-1)
			dateFormatCombo.select(index);
		else
			dateFormatCombo.select(0);			

		// Set selection for time format combo box.
		index = -1;
		for (int i = 0; i < LogUIConstants.TIME_FORMAT_LIST.length; i++) {
			if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) {
				index = i;
				break;
			}
		}
		if (index>-1)
			timeFormatCombo.select(index);
		else
			timeFormatCombo.select(0);
	}
	
	public void init(IWorkbench workbench) {
	}
	protected void performDefaults() {
		//super.performDefaults();

		selectFormatComboBoxes(
				_preferenceStore.getDefaultString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE),
				_preferenceStore.getDefaultString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME)
			);

	}
	public boolean performOk() {
		// Apply selection for date format combo box.
		String selectedDateFormat =
			LogUIConstants.DATE_FORMAT_LIST[dateFormatCombo.getSelectionIndex()];
		boolean dateFmtChanged = false;
		if(!_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_DATE).equals(selectedDateFormat))
			dateFmtChanged = true;

		_preferenceStore.setValue(
			LogUIConstants.LOG_ANALYZER_FORMAT_DATE,
			selectedDateFormat);

		// Apply selection for time format combo box.
		String selectedTimeFormat =
			LogUIConstants.TIME_FORMAT_LIST[timeFormatCombo.getSelectionIndex()];
		boolean timeFmtChanged = false;
		if(!_preferenceStore.getString(LogUIConstants.LOG_ANALYZER_FORMAT_TIME).equals(selectedTimeFormat))
			timeFmtChanged = true;

		_preferenceStore.setValue(
			LogUIConstants.LOG_ANALYZER_FORMAT_TIME,
			selectedTimeFormat);

		// Save the preferences.
		LogUIPlugin.getDefault().savePluginPreferences();
		
		if(dateFmtChanged || timeFmtChanged)	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.PROPERTY_CHANGE, this));
		
		return true;
	}
}