/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColumnData.java,v 1.5 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.preference.*;


public class ColumnData {
	private String _name;
	private boolean _visible = false;

public ColumnData(String name, boolean visible) {
		_name = name;
		_visible = visible;
	}

	   /**
     * createColumnData creates an ArrayList of ColumnData information from
     * the data stored in the preferences store.
     * The data in the preferences store is stored as a series of column definitions
     * separated by commas.  For a description of an individual column definition, see
     * addColumnData.
     * @param String the key to extract the column definition string from the preferences
     * store.
     */
	public static ArrayList createColumnData(String preferenceKey, String defaultColumns) {
		String preferenceColumns = LogUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
		if (preferenceColumns == null || preferenceColumns.length() == 0) {
			preferenceColumns = defaultColumns;
		}
	    return createColumnDataFromString(preferenceColumns);
	}
	
	public static ArrayList createColumnDataFromString(String preferenceColumns) {
		
		ArrayList columnDataList=null;
			
		if (preferenceColumns != null && !preferenceColumns.equals("")) {
			
			// Walk the data and count how many columns the table should have
			// and then allocate the column ArrayList using that size.			
			int count = 1;
			for (int i = preferenceColumns.indexOf(" "); i != -1; i = preferenceColumns.indexOf(",",i+1)) {
				count++;
			}
			columnDataList = new ArrayList(count);
			
			// Walk the data again parsing each column data template and adding it
			// to the column data array list.
			int idx = 0;
			String columnDataTemplate;
			while (idx != -1) {
				idx = preferenceColumns.indexOf(" ");
				
				if (idx != -1) {
					// For all but the last column definition
					columnDataTemplate = preferenceColumns.substring(0, idx);
					preferenceColumns = preferenceColumns.substring(idx + 1);
				}
				else {
					// For the last column definition.
					columnDataTemplate = preferenceColumns;
				}
				addColumnData(columnDataTemplate, columnDataList);
			}
		}
		return columnDataList;
	}
		/**
	 * addColumnData parses a single column definition and adds the defintion
	 * to the ColumnData array list.
	 * @param column java.lang.String containing the column template information
	 * The column template consists of the column name followed by a : followed by the
	 * visiblity flag true or false, followed by a :
	 * @param ArrayList containing the ColumnData created from the template
	 */
	private static void addColumnData(String columnTemplate, ArrayList list) {

		String columnName = "";
		boolean visible = false;
		
		// Parse off the column name.
		int idx = columnTemplate.indexOf(":");
		if (idx != -1) {
			columnName = columnTemplate.substring(0, idx);
			columnTemplate = columnTemplate.substring(idx + 1);
		}
		else
		   columnName = columnTemplate;
		   
		if(columnTemplate.equals("1"))	
		   visible = true;
       		
		list.add(new ColumnData(columnName, visible));
	}
	/**
	 * setColumns saves a new set of ColumnData from the newList to the currentList and
	 * then serializes the data and persists it to the preferences store.
	 *
	 * @param java.util.ArrayList newList is the new ColumnData information
	 * @param java.util.ArrayList currentList is the current ColumnData information
	 * @param java.lang.String preferenceKey is the key to store the serialized data in the
	 * preferences store.
	 */
	public static void setColumns(List newList, List currentList, String preferenceKey, IPreferenceStore store) {
		// Replace the current list data with the new list data
		currentList.clear();
		currentList.addAll(newList);
		setColumns(currentList, preferenceKey, store);
	}
	
	public static void setColumns(List currentList, String preferenceKey, IPreferenceStore store) {
		
		
		// Create the column data template string to save in the preferences store
		String columns = getPreferenceString(currentList);
		// Save the column data template into the preferences.
		store.setValue(preferenceKey, columns);
	}
	
	public static String getPreferenceString(List currentList){
		String columns = "";
		String columnName = "";
		for (int i = 0; i < currentList.size(); i++) {
			ColumnData columnData = (ColumnData)currentList.get(i);
			columnName = columnData.name();
				
			if(columnData.visible())
				columns = columns + " " + columnName + ":1";
			else
				columns = columns + " " + columnName + ":0";				
		}
		return columns.trim();
	}
		
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:14:41 PM)
	 * @return java.lang.String
	 */
	public String name() {
		return _name;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 2:15:04 PM)
	 * @param name java.lang.String
	 */
	public void name(String name) {
		_name = name;
	}
	
	
	public boolean visible() {
		return _visible;
	}
	
	public void visible(boolean visible)
	{
		_visible = visible;
	}
	
}