/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DoubleCList.java,v 1.8 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;


public class DoubleCList
{
  Group _group;
  Composite groupWidget;  

  public    CList     sourceList;
  public    CList     targetList;
  public    Label     targetListLabel;
  public    Label     sourceListLabel;

  public  Button    add;
  public  Button    remove;
  public  Button    addAll;
  public  Button    removeAll;
  
  public Button moveUp;
  public Button moveDown;
  
  private ArrayList listeners = new ArrayList();	  

  private ListSelListener lstListener = null;
  
  class ListSelListener implements SelectionListener
  {
	public void widgetSelected(SelectionEvent e)  
	{
//    System.out.println("widgetSelected: " + e);
	  //allow only one list to have selection 
	  if(e.widget == sourceList.getList() && sourceList.getSelectedItem() != null)
		targetList.clearSelection();                          
	  else if(e.widget == targetList.getList() && targetList.getSelectedItem() != null)
		sourceList.clearSelection();
	  if(e.widget != sourceList.getList() && e.widget!=targetList.getList()){
		if(e.data!=sourceList){	
			e.data = new Integer(RecordChangeEvent.SORT_COL_CHANGE);
		}
		DoubleCList.this.fireSelectionNotification(e);		  
	  
	  }
     updateButtons();
	}
	  
	public void widgetDefaultSelected(SelectionEvent e)  
	{
//    System.out.println("widgetDoubleSelected: " + e);
 	 
	   if(e.widget == sourceList.getList())
	   {
		 Object item = sourceList.getSelectedItem();
		 if(item != null)
		 {
		   sourceList.remove(item);             
		   targetList.add(item);
		   sourceList.clearSelection();
                     
		 }
	   }
	   else if(e.widget == targetList.getList())
	   {
		 Object item = targetList.getSelectedItem();
		 if(item != null)
		 {
		   targetList.remove(item);             
		   sourceList.add(item);
		   targetList.clearSelection();
                          
		 }
	   }
	   e.data = new Integer(RecordChangeEvent.SORT_COL_CHANGE);
	   DoubleCList.this.fireSelectionNotification(e);        

	}
  }

  
  class ButtonListener implements SelectionListener
  {
	public void widgetDefaultSelected(SelectionEvent e){	
	}
	
	public void widgetSelected(SelectionEvent e) 
	{

		if(e.widget == add)
		{
		  String[] items= sourceList.getSelectedItems();
		  for (int i = 0; i < items.length; i++)
		  {
			targetList.add(items[i]);
			sourceList.remove(items[i]);
		  }
		  sourceList.clearSelection();
          
		}
		else if(e.widget == addAll)
		{
		  for (int i=0; i < sourceList.getList().getItemCount(); i++)
		  {
			 Object item = sourceList.getItem(i);
			 targetList.add(item);
		  }
		  sourceList.getList().removeAll();
         
		}
		else if(e.widget == remove)
		{
		  String[] items = targetList.getSelectedItems();
		  for (int i = 0; i < items.length; i++)
		  {
			sourceList.add(items[i]);
			targetList.remove(items[i]);
		  }
		  targetList.clearSelection();
           
		}
		else if(e.widget == removeAll)
		{
		  for (int i=0; i < targetList.getList().getItemCount(); i++)
		  {
			 Object item = targetList.getItem(i);
			 sourceList.add(item);
		  }
		  targetList.getList().removeAll();
         
		}
		else if (e.widget == moveUp)
		{
			int[] indices = targetList.getSelectedIndices();
			Arrays.sort(indices);
			
			// start from the top
			for (int i=0;i<indices.length;++i)
			{
				String oldStr = targetList.getList().getItem(indices[i] - 1);
				String newStr = targetList.getList().getItem(indices[i]);
				targetList.getList().setItem(indices[i] - 1, newStr);
				targetList.getList().setItem(indices[i], oldStr);
				--indices[i];
			}
			targetList.getList().setSelection(indices);
		}
		else if (e.widget == moveDown)
		{
			int[] indices = targetList.getSelectedIndices();
			Arrays.sort(indices);
			
			// start from the bottom
			for (int i=indices.length-1;i>=0;--i)
			{
				String oldStr = targetList.getList().getItem(indices[i] + 1);
				String newStr = targetList.getList().getItem(indices[i]);
				targetList.getList().setItem(indices[i] + 1, newStr);
				targetList.getList().setItem(indices[i], oldStr);
				++indices[i];
			}
			targetList.getList().setSelection(indices);
		}

		e.data = new Integer(RecordChangeEvent.SORT_COL_CHANGE);
		DoubleCList.this.fireSelectionNotification(e);        


	}
  }


  public DoubleCList(Composite parent, int style, String groupText,
					 String sourceTextID, String targetTextID)
  {
	_group = new Group(parent, style);
	_group.setText(groupText);
	
	GridLayout layout= new GridLayout();
	layout.verticalSpacing= -10;
	layout.horizontalSpacing= 0;    
	_group.setLayout(layout);
	_group.setLayoutData(GridUtil.createFill());
	
	createDoubleList(_group, sourceTextID, targetTextID);

	//add listeners
	ButtonListener btnListener = new ButtonListener(); 
	add.addSelectionListener(btnListener);
	remove.addSelectionListener(btnListener);
	addAll.addSelectionListener(btnListener);;
	removeAll.addSelectionListener(btnListener);;
	
	moveUp.addSelectionListener(btnListener);;
	moveDown.addSelectionListener(btnListener);;
	
	//double-click action
	lstListener = new ListSelListener();
	sourceList.addSelectionListener(lstListener);
	targetList.addSelectionListener(lstListener);
	
    updateButtons();
	///////////////////
  }  
  private void addItems(CList list, java.util.List items)
  {
	for (int i=0; i<items.size(); i++)
	{
	   Object item = items.get(i);
	   if(item != null && !item.toString().trim().equals(""))
		   list.add(item);
	}
  }  
  public void addSourceItem(String item)
  {
	java.util.List items = new ArrayList(1);
	items.add(item);
	  
	addItems(sourceList, items);
  }  
  public void addSourceItems(java.util.List items)
  {
	addItems(sourceList, items);
  }  
  public void addTargetItem(String item)
  {
	java.util.List items = new ArrayList(1);
	items.add(item);
	addItems(targetList, items);
  }  
  public void addTargetItems(java.util.List items)
  {
	addItems(targetList, items);
  }  
  /**
  * Create double list components
  */
  public void createDoubleList(Composite parent, 
					 String sourceTextID, String targetTextID)    
  {
	  GridData spec;
	  
	// Create the grid.
	groupWidget = parent;

	GridLayout layout = new GridLayout();
	layout.numColumns = 4;
	groupWidget.setLayout(layout);

	sourceList = new CList(groupWidget, sourceTextID);  
	sourceList.getList().setLayoutData(GridUtil.createFill());  
	
	// Create the grid. 
	Composite buttonWidget = new Composite (groupWidget, SWT.NULL);   
	GridLayout blayout = new GridLayout();
	blayout.numColumns = 1;
	buttonWidget.setLayout(blayout);     
	
	Label label = new Label (buttonWidget, SWT.PUSH);
	label.setText("");
	spec = new GridData();
	spec.grabExcessVerticalSpace = true;
	spec.verticalAlignment = GridData.FILL;
	label.setLayoutData(spec);
	
	add = new Button(buttonWidget, SWT.PUSH);
	add.setText(LogUIPlugin.getResourceString("LEFT_TO_RIGHT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	add.setLayoutData(spec);

	remove = new Button(buttonWidget, SWT.PUSH);
	remove.setText(LogUIPlugin.getResourceString("RIGHT_TO_LEFT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	remove.setLayoutData(spec);
		
	new Label(buttonWidget, SWT.NONE);
		
	addAll = new Button(buttonWidget, SWT.PUSH);
	addAll.setText(LogUIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	addAll.setLayoutData(spec);
	
	removeAll = new Button(buttonWidget, SWT.PUSH);
	removeAll.setText(LogUIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	removeAll.setLayoutData(spec);

	Label label1 = new Label (buttonWidget, SWT.PUSH);
	label1.setText("");
	spec = new GridData();
	spec.grabExcessVerticalSpace = true;
	spec.verticalAlignment = GridData.FILL;
	label.setLayoutData(spec);
			
	targetList = new CList(groupWidget, targetTextID);
	targetList.getList().setLayoutData(GridUtil.createFill());
	
	Composite button2Widget = new Composite (groupWidget, SWT.NULL);   
	blayout = new GridLayout();
	blayout.numColumns = 1;
	button2Widget.setLayout(blayout);     
	
	label = new Label (button2Widget, SWT.PUSH);
	label.setText("");
	spec = new GridData();
	spec.grabExcessVerticalSpace = true;
	spec.verticalAlignment = GridData.FILL;
	label.setLayoutData(spec);
	
	moveUp = new Button(button2Widget, SWT.PUSH);
	moveUp.setText(LogUIPlugin.getResourceString("MOVEUP_TEXT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	moveUp.setLayoutData(spec);
	
	moveDown = new Button(button2Widget, SWT.PUSH);
	moveDown.setText(LogUIPlugin.getResourceString("MOVEDOWN_TEXT"));
	spec = new GridData();
	spec.horizontalAlignment = GridData.FILL;
	moveDown.setLayoutData(spec);
  }  

	// Initialize the list on the left.
	public void initializeSourceList(ArrayList arrayList) {
		Object[] list = arrayList.toArray();
		for (int idx = 0; idx < list.length; idx++) {
			sourceList.add(list[idx].toString());
		}

		if(arrayList.size()>0){
			sourceList.setSelectedIndex(0);
		}
	}

	// Initialize the list on the right.
	public void initializeTargetList(ArrayList arrayList) {
		Object[] list = arrayList.toArray();
		for (int idx = 0; idx < list.length; idx++) {
			targetList.add(list[idx].toString());
		}
	}


/**
 * Insert the method's description here.
 * Creation date: (10/31/2000 3:10:43 PM)
 * @param enable boolean
 */
public void enable(boolean enable)
{
	_group.setEnabled(enable);
	add.setEnabled(enable);
	addAll.setEnabled(enable);
	remove.setEnabled(enable);
	removeAll.setEnabled(enable);
	
	moveUp.setEnabled(enable);
	moveDown.setEnabled(enable);

	sourceList.enable(enable);
	targetList.enable(enable);
}
  public Object findInList( CList list, Object obj)
  {
	 for (int i=0; i<list.getList().getItemCount(); i++)
	 {
		Object item = list.getItem(i);
		if (itemsEqual(item, obj))
		   return item;
	 }
	 return null;
  }  
  private java.util.List getItems(CList list)
  {
	java.util.List items = new ArrayList();
	 for (int i=0; i<list.getList().getItemCount(); i++)
	 {
		Object item = list.getItem(i);
		if(item != null && !item.toString().trim().equals(""))
			items.add(item);
	 }      
	 return items;
  }  
  public java.util.List getSourceItems()
  {
	return getItems(sourceList);
  }  
  public java.util.List getTargetItems()
  {
	return getItems(targetList);
  }  
  public String getText()
  {
	return getTargetItems().toString();
  }  
  public Composite getWidget()
  {
	  return groupWidget;
  }  
  private boolean isInList( CList list, Object obj)
  {
	 for (int i=0; i<list.getList().getItemCount(); i++)
	 {
		Object item = list.getItem(i);
		if (itemsEqual(item, obj))
		   return true;
	 }
	 return false;
  }  
  public boolean isInSourceList(Object obj)
  {
	 return isInList(sourceList, obj);
  }  
  public boolean isInTargetList(Object obj)
  {
	 return isInList(targetList, obj);
  }  
  private boolean itemsEqual(Object item1, Object item2)
  {
	 if (item1.toString().equals(item2.toString()))
		return true; 
  
	 return false;
  }  
  public void removeAll()
  {
	  targetList.getList().removeAll();
	  sourceList.getList().removeAll();   
  }  
  private void removeFromList(CList list, Object obj)
  {
	for (int i=0; i < list.getList().getItemCount(); i++)
	{
		Object item = findInList(list, obj);
		if (item != null)
		   list.remove(item);
	}
  }  
  public void removeFromSource(Object obj)
  {
	 removeFromList(sourceList, obj);
  }  
  public void removeFromTarget(Object obj)
  {
	 removeFromList(targetList, obj);
  }  
  public void setEnabled(boolean b)
  {
	  targetList.getList().setEnabled(b);
	  sourceList.getList().setEnabled(b);     
  }  
   public void setFocus()
   {
	   sourceList.setFocus();
   }   
  public void setToolTipText(String text)
  {
	 sourceList.setToolTipText(text);
	 targetList.setToolTipText(text);    
  }
  
  public void addSelectionListener(SelectionListener listener){
	
	if(!listeners.contains(listener)){
		listeners.add(listener);
	}  
  }
  
  public void removeSelectionListener(SelectionListener listener){
  	listeners.remove(listener);
  	sourceList.removeSelectionListener(lstListener);
  	targetList.removeSelectionListener(lstListener);
  }
  
  public void fireSelectionNotification(SelectionEvent e){

  	for (int i = 0; i < listeners.size(); i++) {
		((SelectionListener)listeners.get(i)).widgetSelected(e);
	}
   updateButtons();
  }
  
  /*
   * Update the Up/Down buttons. Up is enabled iff the entire selection can
   * move up, and Down iff the entire selection can move down. If the selection
   * is empty, both are disabled.
   */
  private void updateButtons()
  {
  	int items = targetList.getItemCount();
	int[] selection = targetList.getSelectedIndices();
	
	if (selection.length == 0)
	{
		moveUp.setEnabled(false);
		moveDown.setEnabled(false);
	}
	else
	{
		int min = items - 1;
		int max = 0;
		
		for (int i=0;i<selection.length;++i)
		{
			min = Math.min(selection[i], min);
			max = Math.max(selection[i], max);
		}
		
		moveUp.setEnabled(min > 0);
		moveDown.setEnabled(max < items - 1);
	} 
  }
}
