/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterListContentProvider.java,v 1.3 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.jface.viewers.*;

public class FilterListContentProvider implements IStructuredContentProvider
{
	private CheckboxTableViewer fViewer;
	protected FilterTableElement fChangedElement;

/**
 * The constructor.
 */
public FilterListContentProvider(CheckboxTableViewer tableViewer)
{
	fViewer = tableViewer;
}
/**
 * The visual part that is using this content provider is about
 * to be disposed. Deallocate all allocated SWT resources.
 */
public void dispose()
{
}
/**
 * 
 */
public void elementChanged(FilterTableElement changedElement, String changedProperty)
{
	fChangedElement = changedElement;
	fViewer.getControl().getDisplay().asyncExec(new Runnable() {
		public void run() {

			fViewer.refresh(fChangedElement);           
		}
	});

}
/**
 * Returns all the markers that should be shown for
 * the current settings.
 */

public Object[] getElements(Object parent)
{
	return ((FilterList)parent).elements();
}
public void inputChanged(Viewer viewer, Object oldInput, Object newInput)
{
	fViewer = (CheckboxTableViewer)viewer;

	// Disconnect from old input.
	if (oldInput != null) {
		if (oldInput instanceof FilterList) {
			((FilterList) oldInput).removeElementChangedListener(this);

		}
	}

	// Connect to new input.
	if (newInput != null) {
		if (newInput instanceof FilterList)
			 ((FilterList) newInput).addElementChangedListener(this);
	}
	
}
/**
 * Not used in the TaskList implementation.
 */
public boolean isDeleted(Object element) {
	return false;
}
}
