/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterTableElement.java,v 1.6 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

//import java.util.ArrayList;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * An element with differently typed properties.
 * Changing a property sends out a DomainEvent.
 */
public class FilterTableElement implements IFilterElement
{
	public static final String P_OPERATOR= "operator_combo";
	public static final String P_ATTRIBUTE= "attribute_combo";
	public static final String P_VALUE= "value_string";	
	
	private String fAttribute;
	private String fOperator;	
	private String fValue;

	private FilterList fParent;

	public FilterTableElement(String attribute, String operator, String value) {
        fAttribute = attribute;		
		fOperator = operator;
		fValue = value;		
	}

    public void setParent(FilterList parent) {
    	fParent = parent;
    }
    
	public String getAttribute() {
		return fAttribute;
	}	
	public String getOperator() {
		return fOperator;
	}
	public String getValue() {
		return fValue;
	}

	public int getAttributeState() {
		for(int idx=0; idx<CBEAdvFilterUI.fAttributeValues.length; idx++)
		{
		  if(CBEAdvFilterUI.fAttributeValues[idx].equals(fAttribute))
			return idx;
		}
		return -1;
	}
	public int getOperatorState() {
		for(int idx=0; idx<CBEAdvFilterUI.fOperatorValues.length; idx++)
		{
		  if(CBEAdvFilterUI.fOperatorValues[idx].equals(fOperator))
		    return idx;
		}
		return -1;
	}

	public void setValue(String value) {
		fValue= value;
		fParent.fireElementChanged(this, P_VALUE);				
	}
	
	public void setOperator(String value) {
		fOperator= value;
		fParent.fireElementChanged(this, P_OPERATOR);				
	}
	
	public void setOperator(int value) {
		fOperator= CBEAdvFilterUI.fOperatorValues[value];
		fParent.fireElementChanged(this, P_OPERATOR);				
	}
	
	public void setAttribute(String value) {
		fAttribute= value;
		fParent.fireElementChanged(this, P_ATTRIBUTE);				
	}
	
	public void setAttribute(int value) {
		fAttribute= CBEAdvFilterUI.fAttributeValues[value];
		fParent.fireElementChanged(this, P_ATTRIBUTE);				
	}
	
	public String toString() {
		return (fAttribute + "," + fOperator + "," + fValue);
	}
	
	public static List createFilterTableElementFromString(String preferenceColumns) {

	List filterTableElemList=null;	
	
	if (preferenceColumns != null && !preferenceColumns.equals("")) {
			
		// Walk the data and count how many columns the table should have
		// and then allocate the column ArrayList using that size.			
		int count = 0;
		for (int i = preferenceColumns.indexOf("!"); i != -1; i = preferenceColumns.indexOf("!",i+1)) {
			count++;
		}
		
		filterTableElemList = new ArrayList(count);
		
		// Walk the data again parsing each column data template and adding it
		// to the column data array list.
		int idx = 0;
		String filterDataTemplate;
		while (idx != -1) {
			idx = preferenceColumns.indexOf("!");
				
			if (idx != -1) {
				// For all but the last column definition
				filterDataTemplate = preferenceColumns.substring(0, idx);
				preferenceColumns = preferenceColumns.substring(idx + 1);
				addFilterData(filterDataTemplate, filterTableElemList);
			}
		}
	}
	return filterTableElemList;
}

	private static void addFilterData(String filterTemplate, List list) {
	
		String filterAttribute = "";
		String filterOperator = "";
		String filterValue = "";
			
		// Parse off the column name.
		int idx = filterTemplate.indexOf(";");
		if (idx != -1) {
			filterAttribute = filterTemplate.substring(0, idx);
			filterTemplate = filterTemplate.substring(idx + 1);
		
			idx = filterTemplate.indexOf(";");
			if (idx != -1) {
				filterOperator = filterTemplate.substring(0, idx);
				filterValue = filterTemplate.substring(idx + 1);
			}
		}
		list.add(new FilterTableElement(filterAttribute, filterOperator, filterValue));
	}

	public static boolean saveFilters(List currentList, String preferenceKey, IPreferenceStore store){
		int s = currentList.size();
		return saveFilters((IFilterElement[]) currentList.toArray(new IFilterElement[s]), preferenceKey, store);
	}
	
	public static String getPreferenceString(IFilterElement[] currentList){
		
		String filterAttribute = "";
		String filterOperator = "";
		String filterValue = "";
		
		// Create the column data template string to save in the preferences store
		String filtersString = "";
		int l = currentList.length;
		for (int i = 0; i < l; i++) {
			IFilterElement filterData = currentList[i];
			filterAttribute = filterData.getAttribute();
			filterOperator = filterData.getOperator();
			filterValue = filterData.getValue();
			
			filtersString = filtersString + filterAttribute+";"+filterOperator+";"+filterValue+"!";			
		}
		
		return filtersString.trim();
		
	}
	
	public static boolean saveFilters(IFilterElement[] currentList, String preferenceKey, IPreferenceStore store) {
		String filtersString = getPreferenceString(currentList);		
		boolean filterChanged = !store.getString(preferenceKey).equals(filtersString);
		// Save the column data template into the preferences.
		store.setValue(preferenceKey, filtersString);
		return filterChanged;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {		
		if(obj instanceof FilterTableElement){
			FilterTableElement element = (FilterTableElement)obj;
			boolean attributes = false;
			boolean operator = false;
			boolean value = false;
			if((element.getAttribute()!=null && fAttribute!=null && fAttribute.equals(element.getAttribute()))){
				attributes = true;
			}else{
				return false;
			}
			if(element.getOperator()!=null && fOperator!=null && fOperator.equals(element.getOperator())){
				operator = true;
			}else{
				return false;
			}
			if(element.getOperator()!=null && fOperator!=null && fOperator.equals(element.getOperator())){
				operator = true;
			}else{
				return false;
			}
			if(element.getValue()!=null && fValue!=null && fValue.equals(element.getValue())){
				value = true;
			}else{
				return false;
			}
			return attributes && operator && value; 
		}else
			return super.equals(obj);
	}
}