/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Sorter.java,v 1.7 2005/05/13 02:37:29 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;

public class Sorter implements Comparator{
		
	protected String[] _sortAttributes;		
	protected int _creationTimeIndex;
	protected int _sortAttributesSize;
	protected int _comp;
	
	protected HashMap _methods = new HashMap();	

	private Method _method;
	private Collator collator = Collator.getInstance();
	public Sorter(){
	}
	
	public Sorter(List sortList) {
		init(sortList);
	}

	private void init(List sortList) {
		_sortAttributes = (String[]) sortList.toArray(new String[sortList.size()]);
		_sortAttributesSize = _sortAttributes.length;
		_creationTimeIndex = sortList.indexOf("CreationTime");
	}
	/**
	*
	* Compares two objects from the vector. Override this method if
	* you want a specialized compare.
	*
	* @param      firstObject  - an Object to be compared
	* @param      secondObject - an Object to be compared
	* @return     the value 0 if the firstObject is equal to the secondObject
	*             a value less than 0 if the firstObject is less than the secondObject
	*             a value greater than 0 if the firstObject is greater than the secondObject
	*/
	
	public int compare(Object obj1, Object obj2) {
		
		if(obj1 == obj2)
		  return 0;
		
		Object val1 = null;
		Object val2 = null;
		
		_comp=0;
		for (int i = 0; i < _sortAttributesSize && _comp==0; i++) {
			String name = _sortAttributes[i];
			if(i== _creationTimeIndex)
			{
				try {
					double d1 = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)obj1);
					double d2 = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)obj2);
					
					if(d1==d2){
						_comp=0;
					}else if(d1<d2)
					{
						_comp = -1;
					}else
					{
						_comp = 1;
						
					}
					continue;
					
				} catch (Exception e) {
					//e.printStackTrace();						
				}
			}
			try{
				_method = getMethod(name, obj1.getClass());
				val1 = _method.invoke(obj1, null);
				_method = getMethod(name, obj2.getClass());
				val2 = _method.invoke(obj2, null);
				
				_comp = compareValues(val1, val2);
			}catch(Exception e){
				if(val1==null && val2!=null){
					_comp = -1;
				}else if(val1!=null && val2==null){
					_comp = 1;
				}else{
					if(obj1==null && obj2!=null){
						_comp = -1;
					}else if(obj1!=null && obj2==null){
						_comp = 1;
					}else{
						_comp = 0;
					}
				}				
			}
		}
		
		return _comp;
	}
	
	protected int compareValues(Object _obj1, Object _obj2){
		
		int comp = -1;

		if(_obj1 instanceof Comparable && _obj2 instanceof Comparable){
			comp = ((Comparable)_obj1).compareTo(_obj2);
		}else{
			comp = collator.compare(_obj1.toString(),_obj2.toString());
		}
        
		return comp;	
	}
	
	
	protected Method getMethod(String name, Class cls) throws Exception {

		Method method = (Method)_methods.get(cls.getName() + name);
		if(method == null)
		{			
		   method = cls.getMethod("get" + name, null);
		   _methods.put(cls.getName() + name, method);			  
		}
			
		return method;

	}
	
	public void setAttributes(List newAttributes){
		init(newAttributes);
	}
}
