/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.HyadesUIPlugin;


public class CreationTimeFeatureFilterAttribute extends BasicFeatureFilterAttribute
{
	public CreationTimeFeatureFilterAttribute(String id, String displayText,EStructuralFeature feature) {
		super(id, displayText, feature,
				new RelationalOperators[] {
				RelationalOperators.get(RelationalOperators.EQ),
				RelationalOperators.get(RelationalOperators.NEQ),
				RelationalOperators.get(RelationalOperators.GT),
				RelationalOperators.get(RelationalOperators.LT),
				RelationalOperators.get(RelationalOperators.GE),
				RelationalOperators.get(RelationalOperators.LE)
		    	},
				false);
	}
	public CreationTimeFeatureFilterAttribute(String id, String displayText) {
		this(id, displayText, CBEPackage.eINSTANCE.getCBECommonBaseEvent_CreationTime());
	}
	
	private String getDateToMicroSeconds (String value)
	{
		String beValue = null;
		
		DateFormat dateFormat = null;
		
		String endOfValue = value.substring(20);
		if (endOfValue.indexOf("+") > 0 || endOfValue.indexOf("-") > 0)
			dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
		else
			dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSz");
		
		try
		{
			Date date = dateFormat.parse(value);
			beValue = Double.toString(date.getTime()*1000);
		}
		catch (Exception e)
		{
			HyadesUIPlugin.logError(e);
		}		
		
		return beValue;
	}
	
	private String getMicroSecondsToDate(String rawValue)
	{
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");		
		Date date = new Date(new Double((Double.valueOf(rawValue).doubleValue()/1000)).longValue());
		return dateFormat.format(date);
	}		
	
	protected String getValueFromDisplayValue(String value)
	{
		return getDateToMicroSeconds(value);
	}	
	
	protected String getDisplayValue(String value)
	{
		return getMicroSecondsToDate(value);
	}	
		

	public String defaultValue() {
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");		
		Date date = new Date();
		return dateFormat.format(date);
	}		
	
	public String validate(String operator, String value) {
		String values[] = getValues(value);
		
		for (int i = 0; i < values.length; i++)
		{
			if (getDateToMicroSeconds(values[i]) == null)
			{
				String errorMsg = TString.change(UIPlugin.getResourceString("STR_ST_FILTER_INVALID_TYPE_FOR_ATTRIBUTE"), "%1", values[i]);
				errorMsg = TString.change(errorMsg, "%2", displayText());
				
				return  errorMsg;
			}
		}
			
		return null;
	}	
}
