/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.impl.CBEPackageImpl;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.internal.filters.ModelUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImportLogFiltersStandardUI extends FiltersStandardTabUI {
	
	public static final String RANGE_BY_EVENTCOUNT_OR_SECONDSCOUNT_BINARY_EXPR_NAME = "internal.rangeByEventCountOrSecondsCount";
	public static final String EVENTCOUNT_OPERAND_NAME = "internal.events";
	public static final String SECONDSCOUNT_OPERAND_NAME = "internal.seconds";		
	
	private static EAttribute ATTRIBUTE_SEVERITY_CONTROL = CBEPackageImpl.init().getCBECommonBaseEvent_Severity();
	private static String[] VALUES_SEVERITY_ERROR = {"50", "70"};
	private static String[] VALUES_SEVERITY_WARNING = {"30", "49"};	
	private static String[] VALUES_SEVERITY_INFORMATION = {"0", "29"};
	
	private static EAttribute ATTRIBUTE_CREATION_TIME = CBEPackageImpl.init().getCBECommonBaseEvent_CreationTime();
	private static EClass ATTRIBUTE_EVENTS = CBEPackageImpl.init().getCBECommonBaseEvent();	
	
	private static EAttribute[] comboAttributes =
	{
		CBEPackageImpl.init().getCBECommonBaseEvent_CreationTime()
	};	
	
	private static RelationalOperators OPERATOR_GT = RelationalOperators.get(RelationalOperators.GT);
	private static RelationalOperators OPERATOR_LT = RelationalOperators.get(RelationalOperators.LT);
	
	private static RelationalOperators OPERATOR_BETWEEN = RelationalOperators.get(RelationalOperators.BETWEEN);	

	
	private Combo orderCombo;
	private Text lengthText;
	private Combo typeOfDurationCombo;
	
	private Button errorSeverityControl;	
	private Button warningSeverityControl;
	private Button informationSeverityControl;
	
	private Button filterByTimeOrEventsControl;
	private Button filterBySeverityControl; 
	
	//private LogFiltersOptionsUI _showCorrelationOption;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.filters.ui.IFiltersStandardTabUI#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public Control createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout());
		
		
		Composite timeEventsContainer = createCompositeWithNumberColumns(content, 1);
		
		filterByTimeOrEventsControl = new Button(timeEventsContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		filterByTimeOrEventsControl.setLayoutData(new GridData());
		filterByTimeOrEventsControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_EVENTS_ONLY_LABEL"));
		filterByTimeOrEventsControl.setSelection(true);
		filterByTimeOrEventsControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_TIME_OR_EVENTS, "=", String.valueOf(filterByTimeOrEventsControl.getSelection()));
				filterByTimeEventsUpdate();
			}
		});

		Composite comboBoxContainers = createCompositeWithNumberColumns(timeEventsContainer, 4);
		
		Label showLabel = new Label(comboBoxContainers, SWT.BOLD);
		showLabel.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SHOW"));
		
		orderCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
		orderCombo.setLayoutData(GridUtil.createHorizontalFill());
		orderCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_ORDER1"));
		orderCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_ORDER2"));
		orderCombo.select(0);
		orderCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_ORDER, "=", orderCombo.getText());
			}
		});
		
		lengthText = new Text(comboBoxContainers, SWT.BORDER);
		lengthText.setLayoutData(GridUtil.createHorizontalFill());
		lengthText.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent key) {
				if (!isInt(lengthText.getText().trim()))
					setError(LogUIPlugin.getResourceString("STR_FILTER_NOT_VALID_INTEGER"));
				else
					noError();
			}
		});
		
		typeOfDurationCombo = new Combo(comboBoxContainers, SWT.BORDER | SWT.READ_ONLY);
		typeOfDurationCombo.setLayoutData(GridUtil.createHorizontalFill());
		typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_EVENTS"));
		typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_SECONDS"));
		typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_MINUTES"));
		typeOfDurationCombo.add(LogUIPlugin.getResourceString("STR_FILTER_BY_COMBO_HOURS"));		
		typeOfDurationCombo.select(0);
		typeOfDurationCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_TYPE, "=", typeOfDurationCombo.getText());
			}
		});

		Composite filterBySeverityContainer = createCompositeWithNumberColumns(content, 1);
		filterBySeverityControl = new Button(filterBySeverityContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		filterBySeverityControl.setLayoutData(new GridData());
		filterBySeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_LABEL"));
		filterBySeverityControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_BY_SEVERITY, "=", String.valueOf(filterBySeverityControl.getSelection()));
				filterBySeverityControlUpdate();
			}
		});
		
		Composite severityTypeContainer = createCompositeWithNumberColumns(filterBySeverityContainer, 2);
		
		Label showLabel2 = new Label(severityTypeContainer, SWT.NULL);
		showLabel2.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_SHOW"));

		errorSeverityControl = new Button(severityTypeContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		errorSeverityControl.setLayoutData(new GridData());
		errorSeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_ERRORS"));
		errorSeverityControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_SEVERITY_ERRORS, "=", String.valueOf(errorSeverityControl.getSelection()));
			}
		});
		
		Label blankLabel1 = new Label(severityTypeContainer, SWT.NULL);		
		
		warningSeverityControl = new Button(severityTypeContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		warningSeverityControl.setLayoutData(new GridData());
		warningSeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_WARNINGS"));
		warningSeverityControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_SEVERITY_WARNINGS, "=", String.valueOf(warningSeverityControl.getSelection()));
			}
		});

		Label blankLabel2 = new Label(severityTypeContainer, SWT.NULL);
		
		informationSeverityControl = new Button(severityTypeContainer, SWT.CHECK);
		//_caseControl.setLayoutData(GridUtil.createHorizontalFill());
		informationSeverityControl.setLayoutData(new GridData());
		informationSeverityControl.setText(LogUIPlugin.getResourceString("STR_FILTER_BY_SEVERITY_INFORMATION"));
		informationSeverityControl.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				//getFilter().putAttributeOperatorValue(FILTER_STANDARD_SEVERITY_INFORMATION, "=", String.valueOf(informationSeverityControl.getSelection()));
			}
		});
		
		
//		_showCorrelationOption = new LogFiltersOptionsUI();
//		_showCorrelationOption.createControl(content);
		
		return content;
	}
	
	
	private Composite createCompositeWithNumberColumns(Composite parent, int numColumns)
	{
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayoutData(GridUtil.createHorizontalFill());
		GridLayout layout = new GridLayout();
		layout.numColumns = numColumns;
		container.setLayout(layout);
		
		return container;
	}
	
	

	private void initializeTimeOrEvents(SimpleSearchQuery filter)
	{
		filterByTimeOrEventsControl.setSelection(false);
		lengthText.setText("10");
		
		
		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
				
			EList filterElements = logicalExpression.getArguments();
			for (int i = 0; i < filterElements.size(); i++)
			{
				Object filterElement = filterElements.get(i);

				if (filterElement instanceof BinaryExpression)
				{
					BinaryExpression be = (BinaryExpression)filterElement;
					
					if (RANGE_BY_EVENTCOUNT_OR_SECONDSCOUNT_BINARY_EXPR_NAME.equals(be.getName()))
					{
						filterByTimeOrEventsControl.setSelection(true);						
						
						Operand leftOperand = be.getLeftOperand();
						RelationalOperators operator = be.getOperator();
						SimpleOperand rightOperand = (SimpleOperand)be.getRightOperands().get(0);
						
						if (RelationalOperators.get(RelationalOperators.LT).equals(operator))
							orderCombo.select(1);
						else
							orderCombo.select(0);

						int value = Integer.parseInt(rightOperand.getValue().toString());
						
						if (EVENTCOUNT_OPERAND_NAME.equals(leftOperand.getName()))
							typeOfDurationCombo.select(0);
						else
						{
							if (value % 3600 == 0)
							{
								typeOfDurationCombo.select(3);
								value = value / 3600;
							}
							else if (value % 60 == 0)
							{
								typeOfDurationCombo.select(2);
								value = value / 60;
							}								
							else
								typeOfDurationCombo.select(1);							
						}
						
						if (rightOperand.getValue() != null)
							lengthText.setText((new Integer(value)).toString());
					}
				}
			}
		}
		
		
		filterByTimeEventsUpdate();		
	}	
	
	public void initializeFrom(SimpleSearchQuery filter) {
		// initialize values
		//_showCorrelationOption.initializeFrom(filter);
		
		filterBySeverityControl.setSelection(false);
		errorSeverityControl.setSelection(false);
		warningSeverityControl.setSelection(false);	
		informationSeverityControl.setSelection(false);		
		
		initializeTimeOrEvents(filter);						
		

		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
				
			EList filterElements = logicalExpression.getArguments();
			for (int i = 0; i < filterElements.size(); i++)
			{
				Object filterElement = filterElements.get(i);

				if (filterElement instanceof LogicalExpression)
				{
					filterBySeverityControl.setSelection(true);					
					EList arguments = ((LogicalExpression)filterElement).getArguments();
					
					for (int j = 0; j < arguments.size(); j++)
					{
						BinaryExpression be = (BinaryExpression) arguments.get(j);	
						EStructuralFeature feature = ((SimpleOperand)be.getLeftOperand()).getFeature();
						RelationalOperators operator = be.getOperator();
						String value = ((SimpleOperand)be.getRightOperands().get(0)).getRawValue();						
						
						if (feature.equals(ATTRIBUTE_SEVERITY_CONTROL))
						{
							if (VALUES_SEVERITY_ERROR[0].equals(value))
								errorSeverityControl.setSelection(true);
							else if (VALUES_SEVERITY_WARNING[0].equals(value))
								warningSeverityControl.setSelection(true);
							else if (VALUES_SEVERITY_INFORMATION[0].equals(value))
								informationSeverityControl.setSelection(true);							
						}
					}
				}
			}
		}

		filterBySeverityControlUpdate();		
	}
	
	private Double convertFromSeconds(Double seconds)
	{
		return seconds;
	}

	private Double convertToSeconds(Double time)
	{
		return time;
	}	
	
	private Double getNumber(String str)
	{
		return new Double(Double.parseDouble(str));
	}
	
	private boolean isNumber(String str)
	{
		try
		{
			Double.parseDouble(str);
			return true;
		}
		catch (NumberFormatException nfe)
		{
			return false;
		}
	}	
	
	private int getIntInSeconds(String str)
	{
		int i = Integer.parseInt(str);
		
		if (typeOfDurationCombo.getSelectionIndex() == 2)
			return i * 60;
		else if (typeOfDurationCombo.getSelectionIndex() == 3)
			return i * 3600;	
		else
			return i;
	}
	
	private boolean isInt(String str)
	{
		try
		{
			Integer.parseInt(str);
			return true;
		}
		catch (NumberFormatException nfe)
		{
			return false;
		}
	}		

	private void applyTimeOrEvents(LogicalExpression logicalExpression)
	{
		if (filterByTimeOrEventsControl.getSelection())
		{		
			BinaryExpression be = ExtensionsFactory.eINSTANCE.createBinaryExpression();
			be.setName(RANGE_BY_EVENTCOUNT_OR_SECONDSCOUNT_BINARY_EXPR_NAME);
			
			Operand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
			
			if (typeOfDurationCombo.getSelectionIndex() == 0)
				leftOperand.setName(EVENTCOUNT_OPERAND_NAME);
			else		
				leftOperand.setName(SECONDSCOUNT_OPERAND_NAME);

			be.setLeftOperand(leftOperand);			
			
			if (orderCombo.getSelectionIndex() == 1)
				be.setOperator(RelationalOperators.get(RelationalOperators.LT));
			else
				be.setOperator(RelationalOperators.get(RelationalOperators.GT));
			
			SimpleOperand rightOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
			rightOperand.setValue(new Integer(getIntInSeconds(lengthText.getText().trim())));
			
			be.getRightOperands().add(rightOperand);
			
			logicalExpression.getArguments().add(be);
		}
	}
	
	public SimpleSearchQuery performApply() {
		//SimpleSearchQuery filter = _showCorrelationOption.performApply();
		SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();

		LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		logicalExpression.setOperator(LogicalOperators.AND_LITERAL);

		applyTimeOrEvents(logicalExpression);

		if (filterBySeverityControl.getSelection())
		{
			LogicalExpression severityLogicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			severityLogicalExpression.setOperator(LogicalOperators.OR_LITERAL);
			EList arguments = severityLogicalExpression.getArguments();
			
			if (errorSeverityControl.getSelection())
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_SEVERITY_CONTROL, OPERATOR_BETWEEN, VALUES_SEVERITY_ERROR, false));
			if (warningSeverityControl.getSelection())
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_SEVERITY_CONTROL, OPERATOR_BETWEEN, VALUES_SEVERITY_WARNING, false));
			if (informationSeverityControl.getSelection())
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_SEVERITY_CONTROL, OPERATOR_BETWEEN, VALUES_SEVERITY_INFORMATION, false));
			
			if (arguments.size() == 0)
			{
				severityLogicalExpression.setOperator(LogicalOperators.AND_LITERAL);				
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_SEVERITY_CONTROL, OPERATOR_GT, "0", false));
				arguments.add(ModelUtils.createBinaryExpression(ATTRIBUTE_SEVERITY_CONTROL, OPERATOR_LT, "0", false));				
			}
			
			logicalExpression.getArguments().add(severityLogicalExpression);
		}
		
		filter.setWhereExpression(logicalExpression);
		
		return filter;
	}
	
	
	private void filterBySeverityControlUpdate()
	{
		boolean filterBySeverity = filterBySeverityControl.getSelection(); 
		errorSeverityControl.setEnabled(filterBySeverity);
		warningSeverityControl.setEnabled(filterBySeverity);
		informationSeverityControl.setEnabled(filterBySeverity);		
	}
	
	private void filterByTimeEventsUpdate()
	{
		boolean filterByTimeOrEvents = filterByTimeOrEventsControl.getSelection(); 
		orderCombo.setEnabled(filterByTimeOrEvents);
		lengthText.setEnabled(filterByTimeOrEvents);
		typeOfDurationCombo.setEnabled(filterByTimeOrEvents);		
	}	
}

