/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogFiltersOptionsUI.java,v 1.5 2005/03/23 23:08:04 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class LogFiltersOptionsUI{
	//public static EAttribute ATTRIBUTE_SHOW_CORRELATION = CBEPackageImpl.init().getCBECommonBaseEvent;
	
	private Button showCorrelationButton;

	public Composite createControl(Composite parent)
	{
		Composite correlationOptions = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		correlationOptions.setLayout(layout);
		correlationOptions.setLayoutData(GridUtil.createHorizontalFill());
		showCorrelationButton = new Button(correlationOptions, SWT.CHECK);
		showCorrelationButton.setText(LogUIPlugin.getResourceString("STR_FILTER_SHOW_CORRELATION_ONLY"));
	
		return correlationOptions;
	}

	public Button getShowCorrelationButton() {
		return showCorrelationButton;
	}

	public void setShowCorrelationButton(Button button) {
		showCorrelationButton = button;
	}

	public void initializeFrom(SimpleSearchQuery simpleSearchQuery)
	{
		if (simpleSearchQuery instanceof TimeBasedCorrelationQuery)
			showCorrelationButton.setSelection(true);
		else
			showCorrelationButton.setSelection(false);
	}
	
	public SimpleSearchQuery performApply() {
		if (showCorrelationButton.getSelection())
		{
			return ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
		}
		else
		{
			return ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
		}
	}
}
