/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CorrelationSelectionWizardPage.java,v 1.4 2005/02/16 22:20:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Nov 20, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.trace.ui.internal.util.CorrelationUI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class CorrelationSelectionWizardPage extends WizardPage {

	private IExtension[] extensions;	
	private CorrelationUI correlationUI;
	/**
	 * @param pageName
	 */
	protected CorrelationSelectionWizardPage(String pageName, IExtension[] extensions) {
		super(pageName);
		setTitle(LogUIPlugin.getResourceString("STR_LOGCORR_PAGE_TITLE"));	
		setDescription(LogUIPlugin.getResourceString("STR_LOGCORR_PAGE_DESC"));
		setImageDescriptor(LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_NEW_CORR_WIZ));	
		
		this.extensions = extensions;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		
		correlationUI = new CorrelationUI(extensions, ContextIds.NEW_CORR_WIZARD_SCHEMA_SEL);
		
		setControl(correlationUI.createControl(parent));
	}
	
	
	public IConfigurationElement getCorrelation(){
		return correlationUI.getCorrelation();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizardPage#isPageComplete()
	 */
	public boolean isPageComplete() {
		if(correlationUI.getSelectedCorrelation()==null){
			return false;
		}
		return true;
	}

}
