/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LocalGLALogger.java,v 1.3 2005/02/16 22:20:28 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class LocalGLALogger implements Log {

	//private XmlGenerator xmlGenerator = new XmlGenerator();
	private List events = new ArrayList();
	private XMLLoader xmlLoader = null;
	private  final String NL = System.getProperties().getProperty("line.separator");
	
	private String detailMessage = null;

	private boolean first = true;

	/**
	 * Trace logging level value.
	 */
	public static final int TRACE_LEVEL = 0;

	/**
	 * Debug logging level value.
	 */
	public static final int DEBUG_LEVEL = 1;

	/**
	 * Information logging level value.
	 */
	public static final int INFO_LEVEL = 2;

	/**
	 * Warning logging level value.
	 */
	public static final int WARN_LEVEL = 3;

	/**
	 * Error logging level value.
	 */
	public static final int ERROR_LEVEL = 4;

	/**
	 * Fatal logging level value.
	 */
	public static final int FATAL_LEVEL = 5;

	/**
	 * The logger's current logging level value.
	 */
	private int loggingLevel;

	public LocalGLALogger() {
		//xmlGenerator.reset(null, true, 8);
		loggingLevel = 0;
	}

	private void logXMLToModel(String xml) {

		byte[] xmlLogEntryBytes = null;

		try {
			xmlLogEntryBytes = xml.getBytes("UTF8");
		} catch (UnsupportedEncodingException u) {
			xmlLogEntryBytes = xml.getBytes();
		}

		xmlLoader.loadEvent(xmlLogEntryBytes, xmlLogEntryBytes.length);
	}

	public String getLogDetails() {
		StringBuffer buffer = new StringBuffer();
		synchronized(events){
			int s = events.size();
			Object object = null;
			if(s>0){
				for(int i=0;i<s;i++){
					object = events.get(i);
					if(object instanceof CommonBaseEvent && object!=null){
						buffer.append(((CommonBaseEvent)object).getMsg());				
						buffer.append(NL);
					}			
				}
				object = events.get(s-1);
				if(object instanceof CommonBaseEvent && object!=null){
					buffer.append(((CommonBaseEvent)object).getMsg());
				}
			}
		}
		detailMessage = buffer.toString();
		return detailMessage;
	}

	public void setXMLLoader(XMLLoader xmlLoader) {
		this.xmlLoader = xmlLoader;
	}

	public boolean isDebugEnabled() {
		return (loggingLevel <= DEBUG_LEVEL);
	}

	public boolean isErrorEnabled() {
		return (loggingLevel <= ERROR_LEVEL);
	}

	public boolean isFatalEnabled() {
		return (loggingLevel <= FATAL_LEVEL);
	}

	public boolean isInfoEnabled() {
		return (loggingLevel <= INFO_LEVEL);
	}

	public boolean isTraceEnabled() {
		return (loggingLevel <= TRACE_LEVEL);
	}

	public boolean isWarnEnabled() {
		return (loggingLevel <= WARN_LEVEL);
	}

	public void trace(Object record) {
		if (isTraceEnabled()) {
			synchronized(events){
				if(!events.contains(record))
					events.add(record);
			}
//			this.detailMessage = xmlGenerator.objectToXML(record);
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}

	}

	public void trace(Object record, Throwable arg1) {
		if (isTraceEnabled()) {
			events.add(record);
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}

	}

	public void debug(Object record) {
		if (isDebugEnabled()) {
			events.add(record);
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}
	}

	public void debug(Object record, Throwable arg1) {
		if (isDebugEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}

	}

	public void info(Object record) {
		if (isInfoEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}

	}

	public void info(Object record, Throwable arg1) {
		if (isInfoEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}

	}

	public void warn(Object record) {
		if (isWarnEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}

	}

	public void warn(Object record, Throwable arg1) {
		if (isWarnEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}
	}

	public void error(Object record) {
		if (isErrorEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}
	}

	public void error(Object record, Throwable arg1) {
		if (isErrorEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}
	}

	public void fatal(Object record) {
		if (isFatalEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}
	}

	public void fatal(Object record, Throwable arg1) {
		if (isFatalEnabled()) {
//			logXMLToModel(xmlGenerator.objectToXML(record));
		}
	}

}
