/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogSetDialog.java,v 1.6 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Map;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogSetDialog extends Dialog {

	private LogSetUI logSetUI;
	private int type;
	private ImportLogWizardPage page;
	private Map logSets;
	private String defaultLogSet;
	private boolean logSetSelChanged=false;
	private boolean currentLogSetChanged=false;
	private String logSetName;
	 
	public LogSetDialog(Shell parentShell, int type) {
		super(parentShell);
		this.type = type;		
	}

	public LogSetDialog(Shell parentShell, int type, ImportLogWizardPage page) {
		super(parentShell);
		this.type = type;
		this.page = page;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {

		
		Composite result = new Composite(parent, SWT.NONE);
		GridData data = GridUtil.createFill();
		result.setLayoutData(data);
		result.setLayout(new GridLayout());
		
		logSetUI = new LogSetUI(this);
		setTitle();
		logSetUI.createContent(result, type);
		
		switch(type)
		{
			case 0:
			//new log set
			org.eclipse.ui.help.WorkbenchHelp.setHelp(
			result,
				LogUIPlugin.getPluginId() + ".ls0000");
			break;
			
			case 1:
			//open log set
			org.eclipse.ui.help.WorkbenchHelp.setHelp(
			result,
				LogUIPlugin.getPluginId() + ".ls0010");
			break;
			
			case 2:
			//edit log set
			org.eclipse.ui.help.WorkbenchHelp.setHelp(
			result,
				LogUIPlugin.getPluginId() + ".ls0020");
			break;
			
			
		}
			
		return result;
		
	}
		
	private void setTitle(){

		switch (type){

			case ImportLogWizardPage.NEW_LOGSET: 
				getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_TITLE"));	
				break;
			case ImportLogWizardPage.OPEN_LOGSET:
				getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_TITLE"));				
				break;
			case ImportLogWizardPage.EDIT_LOGSET:
				getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_TITLE"));
				break;
			case ImportLogWizardPage.RENAME_LOGSET:
				getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REN_TITLE"));
		}
		
	}
	
	public void setOKButtonEnabled(boolean enabled){
		Button button = getButton(IDialogConstants.OK_ID);
		if(button!=null){
			button.setEnabled(enabled);
		}
		
	}
	
	public Map getLogSets(){
		return logSets;
	}
	
	public void setLogSets(Map newSet){
		logSets = newSet;
	}
	
	public String getDefaultLogSet(){
		return defaultLogSet;
	}
	
	public void setDefaultLogSet(String newDefault){
		defaultLogSet = newDefault;
	}
	
	public void setLogSetSelectionChanged(boolean value){
		logSetSelChanged = value;	
	}
	
	public boolean hasLogSetSelectionChanged(){
		return logSetSelChanged;
	}
	
	public boolean hasCurrentLogSetChanged(){
		return currentLogSetChanged;	
	}
	
	public void setCurrentLogSetChanged(boolean newVal){
		currentLogSetChanged = newVal;
	}
	
	public String getCurrentLogSet(){ 
		return page.getLogSetManager().getDefaultLogSet();
	}
	
	public String getLogSetName(){
		return logSetName;
	}
	
	public void setLogSetName(String newText){
		logSetName = newText;
	}
		
}