/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ParserField.java,v 1.5 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.logging.parsers.IWidgetListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ParserField
{
	protected String _id="";
	protected String _name="";
	protected String _defaultValue="";	
	protected boolean _useBrowse;
	protected String _browseFilters="*"; 
	protected String _tooltip="";
	protected String _contextId="";
	protected String uiType ="text_field";
	protected String _listener = "";
	protected IConfigurationElement _config;
	protected IWidgetListener _listenerInstance = null;
	
	
	public ParserField(String id, String name)
	{
		if(id != null)
			_id = id;
		if(name != null)	
			_name = name;
	}
	
	public void setDefaultValue(String val)
	{
		if(val != null)
			_defaultValue = val;
	}
	
	public void useBrowse(boolean useBrowse)
	{
		_useBrowse = useBrowse;
	}
	
	public void setFilters(String filters)
	{		
		_browseFilters = filters;
	}
	
	public void setTooltip(String tooltip)
	{
		if(tooltip != null)
			_tooltip = tooltip;
	}
	
	public void setContextId(String contextId)
	{
		if(contextId != null)
			_contextId = contextId;
	}
	
	public void setConfigurationElement(IConfigurationElement elem) 
	{
		_config = elem;
	}
	
	public void setListener(String listener)
	{
		if (listener != null)
			_listener = listener;
	}
	
	public String getDefaultValue()
	{
		return _defaultValue;
	}
	
	public String getId()
	{
		return _id;
	}
	
	public String getName()
	{
		return _name;
	}
	
	public String getContextId()
	{
		return _contextId;
	}
	
	public String getTooltip()
	{
		return _tooltip;
	}
	
	public String getListener()
	{
		return _listener;	
	}
	
	public boolean useBrowse()
	{
		return _useBrowse;
	}
	
	public String getFilters()
	{
		return _browseFilters;
	}
	/**
	 * Returns the uiType.
	 * @return String
	 */
	public String getUiType() {
		return uiType;
	}

	/**
	 * Sets the uiType.
	 * @param uiType The uiType to set
	 */
	public void setUiType(String uiType) {
		if (uiType != null)
			this.uiType = uiType;
	}


	/**
	 * Returns an instance of the listener class that may have been specified
	 * for a field.
	 * 
	 * @return An instance of the field's listener class.
	 */
	public IWidgetListener getListenerInstance() {
		
		/* If it has already been once retrieved, then return it */
		if (_listenerInstance != null)
			return _listenerInstance; 
		
		try {
			
			/* Return null if the configuration has not been set */
			if (_config == null)
				return null;

			/* Create and return the executable of the specified listener 
			 * class only if it is */  
			Object elem = _config.createExecutableExtension("listener");	
			if (elem != null && elem instanceof IWidgetListener)
			{
				_listenerInstance = (IWidgetListener)elem;
				return _listenerInstance;
			}			 
			else
				System.err.println("Error resolving the listener: " + _listener + ".  Ensure that the class implements IWizardListener");
							
		}
		catch (CoreException exc) {
			return null;
		}
		
		return null;
	}
}
