/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: INamedElement.java,v 1.5 2005/02/16 22:21:43 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.runtime.datapool;

/**
 * This class defines the base interface for all named elements.  Each named
 * element has a standard set of associated properties.  Any undefined property
 * will return <code>null</code> for the property value.
 * 
 * @see	IDatapool
 * @see IDatapoolEquivalenceClass
 * @see	IDatapoolVariable
 */
public interface INamedElement
{
	
	/**
	 * Accessor method for the GUID for the element.  <code>null</code>
	 * is returned if no GUID has been defined for the element.
	 * 
	 * @return The GUID for the element.
	 */
	public String getId();
	
	/**
	 * Accessor method for the name of the element.  <code>null</code>
	 * is returned if no name has been defined for the element.
	 * 
	 * @return The name of the element.
	 */
	public String getName();
	
	/**
	 * Accessor for the description associated with the element.
	 * <code>null</code> is returned if no description has been associated 
	 * with the element.
	 * 
	 * @return The description associated with the element.
	 */
	public String getDescription();
	
}
