/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AdapterLogOutputter.java,v 1.3 2005/02/16 22:20:30 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.config.outputters;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.util.Messages;

/**
 * @author smith
 *
 * This class is an outputter to write CBE events created by GLA to an 
 * Apache Commons logger. 
 */
public class AdapterLogOutputter extends StaticParserOutputter {
	
	public void update() throws AdapterInvalidConfig {
		
		/* first get the basic configuration set */
		super.update();

		if (outLogger == null) {
			throw new AdapterInvalidConfig(Messages.getString("HyadesGA_AdapterLogOutputter_No_Logger_ERROR_"));
		}
	}
	/**
	 * Set the output logger.
	 * @param outLogger The outLogger to set.
	 */
	public void setOutLogger(Log outLogger) {
		this.outLogger = outLogger;
	}
}
