/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILogRecordCorrelationEngine.java,v 1.6 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.extensions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;

/**
 * 
 *
 */
public interface ILogRecordCorrelationEngine {
	
	/**This method sets the log record associations 
	 * according to a particular correlation schema.
	 * @param correlationContainerProxy - the correlation container, this should point to a correlation container and a correlation engine
	 * @param listOfRecordLists - the list of RecordLists
	 * where each RecordList contains records of a particular log.
	 * @param monitor - an activity progress monitor or
	 *    <code>null</code> if monitoring is not required.
	 * @return void
	 */
	public void correlate(CorrelationContainerProxy correlationContainerProxy, EList listOfRecordLists, ICorrelationMonitor monitor);
}
