/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILogRecordFilter.java,v 1.4 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.extensions;

/**
 * ILogRecordFilter defines an interface for log records filters.
 *
 */
import org.eclipse.emf.common.util.EList;

public interface ILogRecordFilter {
	
	/** this method returns a list of log records 
	 * which are of interest in the particular scope.
	 * @param recordList - the list of log records
	 * @return filtered list of log records
	 */
	public EList filter(EList recordList);

}
