/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProgressMonitorAdapter.java,v 1.3 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.internal.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.logc.extensions.ICorrelationMonitor;

/**
 * An adapter between the correlation monitor interface <code>ICorrelationMonitor</code>
 * and Eclipse's <code>IProgressMonitor</code>. Simply forwards
 * all calls from the <code>ICorrelationMonitor</code> to the
 * <code>IProgressMonitor</code>.
 * 
 * @author apnan
 * @since 3.0
 */
public class ProgressMonitorAdapter implements ICorrelationMonitor {
	private IProgressMonitor monitor;
	
	/**
	 * Constructs a new adapter.
	 * 
	 * @param monitor the monitor to forward the calls to.
	 */
	public ProgressMonitorAdapter(IProgressMonitor monitor) {
		this.monitor = monitor;
	}
	
	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#beginTask(java.lang.String, int)
	 */
	public void beginTask(String name, int totalWork) {
		monitor.beginTask(name, totalWork);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#done()
	 */
	public void done() {
		monitor.done();
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#internalWorked(double)
	 */
	public void internalWorked(double work) {
		monitor.internalWorked(work);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#isCanceled()
	 */
	public boolean isCanceled() {
		return monitor.isCanceled();
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#setCanceled(boolean)
	 */
	public void setCanceled(boolean value) {
		monitor.setCanceled(value);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#setTaskName(java.lang.String)
	 */
	public void setTaskName(String name) {
		monitor.setTaskName(name);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#subTask(java.lang.String)
	 */
	public void subTask(String name) {
		monitor.subTask(name);
	}

	/**
	 * @see org.eclipse.core.runtime.IProgressMonitor#worked(int)
	 */
	public void worked(int work) {
		monitor.worked(work);
	}
}
