/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestInvocation.java,v 1.3 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.test.common.event.VerdictEvent;


/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestInvocation
extends Action
{
	private static List verdictListeners = new ArrayList();

	public static void addListener(IVerdictListener verdictListener)
	{
		if((verdictListener != null) && (!verdictListeners.contains(verdictListener)))
			verdictListeners.add(verdictListener);
	}
	
	public static void removeListener(IVerdictListener verdictListener)
	{
		verdictListeners.remove(verdictListener);
	}
	
	public static void removeListeners()
	{
		verdictListeners.clear();
	}
	
	protected void notifyVerdictListeners()
	{
		for (Iterator i = verdictListeners.iterator(); i.hasNext();)
			((IVerdictListener)i.next()).handleVerdict(this);
	}

	private String testId;
	private Test test;
	private VerdictEvent verdictEvent;
	private int executionCount;
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.model.Action#dispose()
	 */
	public void dispose()
	{
		test = null;
		verdictEvent = null;
		super.dispose();
	}
	
	public Test getTest()
	{
		return test;
	}

	public void setTest(Test newTest)
	{	
		this.test = newTest;
		
		if(test == null)
		{
			testId = null;
		}
		else
		{
			testId = test.getId();
		}
	}

	public String getTestId()
	{
		return testId;
	}
	
	public void setTestId(String testId)
	{
		if(test != null)
		{
			if(test.getId().equals(testId))
				return;
			test = null;
		}

		this.testId = testId;
	}
	
	public VerdictEvent getVerdictEvent()
	{
		return verdictEvent;
	}

	public void setVerdictEvent(VerdictEvent verdictEvent)
	{
		this.verdictEvent = verdictEvent;
		executionCount++;
		
		notifyVerdictListeners();
	}
	
	public int getExecutionCount()
	{
		return executionCount;
	}
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.model.NamedElement#toString()
	 */
	public String toString()
	{
		if(getExecutionCount() > 0)
			return super.toString();
		return super.toString() + "    ";
	}
}
