/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Arbiter.java,v 1.4 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model.util;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class Arbiter
{
	public VerdictEvent analyse(TestInvocation testInvocation)
	{
		if(testInvocation.getTest() instanceof TestCase)
			return testInvocation.getVerdictEvent();

		Collection executedTestInvocations = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();		
		TestSuite testSuite = (TestSuite)testInvocation.getTest();
		int verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
		if(executedTestInvocations != null)
		{
			for (Iterator i = executedTestInvocations.iterator(); i.hasNext();)
			{
				TestInvocation ti = (TestInvocation)i.next();
				if(ModelUtil.isOwnerTestSuite(testSuite, ti))
				{
					if(ti.getVerdictEvent() == null)
						continue;
						
					int aVerdict = ti.getVerdictEvent().getVerdict();
					if(VerdictEvent.VERDICT_ERROR == aVerdict)
					{
						verdict = VerdictEvent.VERDICT_ERROR;
						break;							
					}
					else if(VerdictEvent.VERDICT_FAIL == aVerdict)
					{
						verdict = VerdictEvent.VERDICT_FAIL;
					}
					else if(VerdictEvent.VERDICT_INCONCLUSIVE == aVerdict)
					{
						if (VerdictEvent.NOT_INITIALIZED_VALUE == verdict ||
							VerdictEvent.VERDICT_PASS == verdict)
							verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
					}
					else if(VerdictEvent.VERDICT_PASS == aVerdict)
					{
						if(VerdictEvent.NOT_INITIALIZED_VALUE == verdict)
							verdict = VerdictEvent.VERDICT_PASS;
					}
				}
			}
		}

		VerdictEvent verdictEvent = ModelUtil.createTestVerdictEvent(testInvocation);
		verdictEvent.setVerdict(verdict);
		return verdictEvent;
	}
	
	public VerdictEvent analyse()
	{
		TestSuite testSuite = ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot();
		if(testSuite == null)
			return null;

		Collection executedTestInvocations = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();
		int verdict = VerdictEvent.NOT_INITIALIZED_VALUE;
		if(executedTestInvocations != null)
		{
			for (Iterator i = executedTestInvocations.iterator(); i.hasNext();)
			{
				TestInvocation testInvocation = (TestInvocation)i.next();
				if(testInvocation.getVerdictEvent() == null)
					continue;
					
				int aVerdict = testInvocation.getVerdictEvent().getVerdict();
				if(VerdictEvent.VERDICT_ERROR == aVerdict)
				{
					verdict = VerdictEvent.VERDICT_ERROR;
					break;							
				}
				else if(VerdictEvent.VERDICT_FAIL == aVerdict)
				{
					verdict = VerdictEvent.VERDICT_FAIL;
				}
				else if(VerdictEvent.VERDICT_INCONCLUSIVE == aVerdict)
				{
					if (VerdictEvent.NOT_INITIALIZED_VALUE == verdict ||
						VerdictEvent.VERDICT_PASS == verdict)
						verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
				}
				else if(VerdictEvent.VERDICT_PASS == aVerdict)
				{
					if(VerdictEvent.NOT_INITIALIZED_VALUE == verdict)
						verdict = VerdictEvent.VERDICT_PASS;
				}
			}
		}
		
		// If our verdict is still uninitialized, then we log an inconclusive verdict
		if ( verdict == VerdictEvent.NOT_INITIALIZED_VALUE )
			verdict = VerdictEvent.VERDICT_INCONCLUSIVE;
			
		VerdictEvent verdictEvent = new VerdictEvent();
		verdictEvent.setOwnerId(ModelUtil.getHierarchyId(testSuite));
		verdictEvent.setVerdict(verdict);
		return verdictEvent;
	}
}