/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ModelUtil.java,v 1.3 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.model.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.IActionOwner;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;


/**
 * @author marcelop
 * @since 1.0.2
 */
public class ModelUtil
{
	public static final Arbiter DEFAULT_ARBITER = new Arbiter();
	public static final ExecutionManager DEFAULT_EXECUTION_MANAGER = new ExecutionManager();
	
	private static List verdicts; 
	private static EventLogger eventLogger;
	
	public static void setEventLogger(EventLogger el)
	{
		eventLogger = el;
	}
	
	public static EventLogger getEventLogger()
	{
		return eventLogger;
	}
	
	public static List getVerdicts()
	{
		if(verdicts == null)
			return Collections.EMPTY_LIST;
		return verdicts;
	}
	
	public static void setVerdicts(List v)
	{
		verdicts = v;
		
		Comparator comparator = new Comparator()
		{
			public int compare(Object o1, Object o2)
			{
				return o1.toString().compareTo(o2.toString());
			}

			public boolean equals(Object obj)
			{
				return (hashCode() != obj.hashCode());
			}
		};
		Collections.sort(verdicts, comparator);
	}
	
	public static Verdict getDefaultVerdict()
	{
		for (Iterator i = getVerdicts().iterator(); i.hasNext();)
		{
			Verdict verdict = (Verdict)i.next();
			if(verdict.isDefault())
				return verdict;
		}
		return null;
	}
	
	public static Verdict getVerdict(int value)
	{
		for (Iterator i = getVerdicts().iterator(); i.hasNext();)
		{
			Verdict verdict = (Verdict)i.next();
			if(verdict.getValue() == value)
				return verdict;
		}
		return null;
	}
	
	public static void clearVerdicts()
	{
		if(verdicts != null)
			verdicts.clear();
	}
	
	public static boolean isOwnerTestSuite(TestSuite testSuite, NamedElement namedElement)
	{
		if(testSuite == DEFAULT_EXECUTION_MANAGER.getRoot())
			return true;
			
		if((testSuite != null) && (namedElement != null))
		{
			if(namedElement instanceof Action)
				return isOwnerTestSuite(testSuite, (NamedElement)((Action)namedElement).getOwner());
				
			if(namedElement instanceof TestCase)
				return (testSuite == ((TestCase)namedElement).getTestSuite());
				
			if(namedElement instanceof TestSuite)
			{
				if(namedElement == testSuite)
					return true;
					
				namedElement = ((TestSuite)namedElement).getTestInvocation();
				return isOwnerTestSuite(testSuite, namedElement);
			}
		}
			
		return false;
	}
	
	public static String getHierarchyId(NamedElement namedElement)
	{
		StringBuffer sb = new StringBuffer();
		getHierarchyId(namedElement, sb);
		if(sb.length() == 0)
			return "";
		
		return sb.deleteCharAt(0).toString();
	}
	
	private static void getHierarchyId(NamedElement namedElement, StringBuffer id)
	{
		if(namedElement == null)
			return;
					
		if(namedElement instanceof Action)
		{
			Action action = (Action)namedElement;
			getHierarchyId((NamedElement)action.getOwner(), id);
		}
		else if(namedElement instanceof TestSuite)
		{
			getHierarchyId(((TestSuite)namedElement).getTestInvocation(), id);
		}
		
		appendHierarchyId(namedElement, id);
	}
	
	public static String appendHierarchyId(NamedElement namedElement, String id)
	{
		StringBuffer sb = new StringBuffer(id);
		appendHierarchyId(namedElement, sb);
		return sb.toString();
	}
	
	private static void appendHierarchyId(NamedElement namedElement, StringBuffer id)
	{
		if(namedElement == null)
			return;
			
		id.append(".").append(namedElement.getId());
		if(namedElement.getIteration() > 0)
			id.append("(").append(namedElement.getIteration()).append(")");
	}
	
	public static VerdictEvent createTestVerdictEvent(TestInvocation testInvocation)
	{
		if((testInvocation == null) || (testInvocation.getTest() == null))
			return null;
			
		StringBuffer sb = new StringBuffer(getHierarchyId(testInvocation));
		appendHierarchyId(testInvocation.getTest(), sb);

		VerdictEvent event = new VerdictEvent();
		event.setOwnerId(sb.toString());
		return event;
	}

	public static TypedEvent createTestTypedEvent(TestInvocation testInvocation)
	{
		if((testInvocation == null) || (testInvocation.getTest() == null))
			return null;
			
		StringBuffer sb = new StringBuffer(getHierarchyId(testInvocation));
		appendHierarchyId(testInvocation.getTest(), sb);

		TypedEvent event = new TypedEvent();
		event.setOwnerId(sb.toString());
		return event;
	}
	
	public static void dispose(NamedElement namedElement)
	{
		if(namedElement != null)
		{
			if(namedElement instanceof IActionOwner)
				dispose(((IActionOwner)namedElement).getActions());
			namedElement.dispose();
		}
	}
	
	public static void dispose(Collection collection)
	{
		if(collection == null)
			return;
		
		for (Iterator i = collection.iterator(); i.hasNext();)
		{
			Object object = i.next();
			if(object instanceof NamedElement)
				dispose((NamedElement)object);
		}	
		
		collection.clear();
	}
	
	public static void closeExecutedTests()
	{
		for(Iterator i = DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations().iterator(); i.hasNext();)
		{
			TestInvocation testInvocation = (TestInvocation)i.next();
			if((testInvocation.getTest() instanceof TestSuite) && (testInvocation.getVerdictEvent() == null))
				getEventLogger().log(ModelUtil.DEFAULT_ARBITER.analyse(testInvocation));
			
			TypedEvent event = createTestTypedEvent(testInvocation);
			event.setType(TypedEvent.STOP);
			getEventLogger().log(event);
		}
	}
}
