/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ActionPanel.java,v 1.3 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.panel;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
abstract class ActionPanel 
extends NamedElementPanel
{
	private JCheckBox synchronizedCheckBox;

	/**
	 * @see CommonAttributesPanel#addControls(JPanel, JPanel)
	 */
	protected void addControls(JPanel northPanel, JPanel centerPanel, JPanel southPanel)
	{
		synchronizedCheckBox = new JCheckBox();
		synchronizedCheckBox.setAlignmentX(Component.LEFT_ALIGNMENT);
		synchronizedCheckBox.setText(RemoteAppResourceBundle.getString("word.BlockSequential"));
		SwingUtil.adjustMnemonic(synchronizedCheckBox);
		
		northPanel.add(synchronizedCheckBox);
	}
	
	/**
	 * @see BasePanel#isValidData(Object)
	 */
	protected boolean isValidData(Object data)
	{
		return super.isValidData(data) && (data instanceof Action);
	}
	
	/**
	 * @see BasePanel#invalidData()
	 */
	protected void invalidData()
	{
		super.invalidData();
		synchronizedCheckBox.setSelected(false);
	}

	/**
	 * @see BasePanel#refreshPanelboolean
	 */
	protected void refreshPanel(boolean sameObject)
	{
		super.refreshPanel(sameObject);
		synchronizedCheckBox.setSelected(getAction().isSynchronous());
	}

	/**
	 * @see BasePanel#setEditable(boolean)
	 */
	protected void setEditable(boolean editable)
	{
		super.setEditable(editable);
		synchronizedCheckBox.setEnabled(editable);
	}
	
	public Action getAction()
	{
		return (Action)getCurrentData();
	}
}
