/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NamedElementPanel.java,v 1.3 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
abstract class NamedElementPanel
extends BasePanel
{
	private JTextField nameText;
	private JTextArea descriptionText;
	
	/**
	 * @see BasePanel#createControl()
	 */
	protected void createControl()
	{
		setLayout(new BorderLayout(0, 5));
		setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		JPanel northPanel = new JPanel(new GridLayout(0, 1, 0, 3));
		add(northPanel, BorderLayout.NORTH);

		JPanel centerPanel = new JPanel();
		centerPanel.setLayout(new BoxLayout(centerPanel, BoxLayout.Y_AXIS));
		add(centerPanel, BorderLayout.CENTER);

		JPanel southPanel = new JPanel(new GridLayout(0, 1, 0, 1));
		add(southPanel, BorderLayout.SOUTH);

		nameText = new JTextField();
		nameText.setAlignmentX(Component.LEFT_ALIGNMENT);
		nameText.addCaretListener(this);
		JLabel label = new JLabel(RemoteAppResourceBundle.getString("label.Name"));
		label.setLabelFor(nameText);
		label.setAlignmentX(Component.LEFT_ALIGNMENT);
		SwingUtil.adjustMnemonic(label);
		
		northPanel.add(label);
		northPanel.add(nameText);
		
		addControls(northPanel, centerPanel, southPanel);

		descriptionText = new JTextArea(3, 0);
		descriptionText.addCaretListener(this);
		label = new JLabel(RemoteAppResourceBundle.getString("label.Description"));
		label.setLabelFor(descriptionText);	
		label.setAlignmentX(Component.LEFT_ALIGNMENT);
		SwingUtil.adjustMnemonic(label);	
		JScrollPane scrollPane = new JScrollPane(descriptionText, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);

		centerPanel.add(label);
		centerPanel.add(Box.createRigidArea(new Dimension(0,5)));
		centerPanel.add(scrollPane);
	}
	
	protected void addControls(JPanel northPanel, JPanel centerPanel, JPanel southPanel)
	{
	}	
		
	/**
	 * @see BasePanel#invalidData()
	 */
	protected void invalidData()
	{
		nameText.setText("");
		descriptionText.setText("");
	}
	
	/**
	 * @see BasePanel#refreshPanel(boolean)
	 */
	protected void refreshPanel(boolean sameObject)
	{
		nameText.setText(BaseString.toString(getNamedElement().getName()));
		descriptionText.setText(BaseString.toString(getNamedElement().getDescription()));
	}

	/**
	 * @see BasePanel#setEditable(boolean)
	 */
	protected void setEditable(boolean editable)
	{
		nameText.setEditable(editable);
		descriptionText.setEditable(editable);
		
		descriptionText.setBackground(nameText.getBackground());
	}
	
	protected NamedElement getNamedElement()
	{
		return (NamedElement)getCurrentData();
	}
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.ui.panel.BasePanel#isValidData(java.lang.Object)
	 */
	protected boolean isValidData(Object data)
	{
		return (data instanceof NamedElement);
	}
}