/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseCardLayout.java,v 1.3 2005/02/16 22:21:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.util;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class BaseCardLayout 
extends CardLayout
{
	private Map tab;
	
	/**
	 * Constructor for BaseCardLayout.
	 */
	public BaseCardLayout()
	{
		super();
		tab = new HashMap();
	}

	/**
	 * Constructor for BaseCardLayout.
	 * @param hgap
	 * @param vgap
	 */
	public BaseCardLayout(int hgap, int vgap)
	{
		super(hgap, vgap);
	}

	/**
	 * @see LayoutManager2#addLayoutComponent(Component, Object)
	 */
	public void addLayoutComponent(Component comp, Object constraints)
	{
		super.addLayoutComponent(comp, constraints);
		tab.put(constraints, comp);
	}

	/**
	 * @see CardLayout#show(Container, String)
	 */
	public Component showAndTell(Container parent, String name)
	{
		super.show(parent, name);
		return getComponent(name);
	}
	
	public Component getComponent(String name)
	{
		return (Component)tab.get(name);
	}
}
