/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OverlayIcon.java,v 1.3 2005/02/16 22:21:49 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.util;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class OverlayIcon
implements Icon
{
	private final static int ROW_TOP = 0;
	private final static int ROW_MIDDLE = 1;
	private final static int ROW_BOTTON = 2;

	private final static int COL_LEFT = 0;
	private final static int COL_MIDDLE = 1;
	private final static int COL_RIGTH = 2;
	
	private Icon[][] icons = new Icon[3][3];  //row, column
	
	public OverlayIcon(Icon baseIcon)
	{
		icons[ROW_MIDDLE][COL_MIDDLE] = baseIcon;
	}
	
	public void setLeftIcon(Icon icon)
	{
		icons[ROW_MIDDLE][COL_LEFT] = icon;
	}

	public void setRightIcon(Icon icon)
	{
		icons[ROW_MIDDLE][COL_RIGTH] = icon;
	}

	public void setLeftTopIcon(Icon icon)
	{
		icons[ROW_TOP][COL_LEFT] = icon;
	}

	public void setTopIcon(Icon icon)
	{
		icons[ROW_TOP][COL_MIDDLE] = icon;
	}

	public void setRightTopIcon(Icon icon)
	{
		icons[ROW_TOP][COL_RIGTH] = icon;
	}

	public void setLeftBottonIcon(Icon icon)
	{
		icons[ROW_BOTTON][COL_LEFT] = icon;
	}

	public void setBottonIcon(Icon icon)
	{
		icons[ROW_BOTTON][COL_MIDDLE] = icon;
	}

	public void setRightBottonIcon(Icon icon)
	{
		icons[ROW_BOTTON][COL_RIGTH] = icon;
	}
	
	/**
	 * @see Icon#getIconHeight()
	 */
	public int getIconHeight()
	{
		return getMaxHeightByRow(ROW_TOP) + getMaxHeightByRow(ROW_MIDDLE) + getMaxHeightByRow(ROW_BOTTON);
	}

	/**
	 * @see Icon#getIconWidth()
	 */
	public int getIconWidth()
	{
		return getMaxWidthByCol(COL_LEFT) + getMaxWidthByCol(COL_MIDDLE) + getMaxWidthByCol(COL_RIGTH);
	}

	/**
	 * @see Icon#paintIcon(Component, Graphics, int, int)
	 */
	public void paintIcon(Component c, Graphics g, int x, int y)
	{
		int maxWidthLeft = getMaxWidthByCol(COL_LEFT);
		x = x + maxWidthLeft;

		int maxHeightTop = getMaxHeightByRow(ROW_TOP);
		y = y + maxHeightTop;

		Icon icon = icons[ROW_MIDDLE][COL_MIDDLE];
		if(icon != null)
		{
			icon.paintIcon(c, g, x, y);
		}

		icon = icons[ROW_MIDDLE][COL_LEFT];
		if(icon != null)
		{
			int _x = x - icon.getIconWidth();
			icon.paintIcon(c, g, _x, y);
		}					
		
		icon = icons[ROW_MIDDLE][COL_RIGTH];
		if(icon != null)
		{
			int _x = x + getMaxWidthByCol(COL_MIDDLE);
			icon.paintIcon(c, g, _x, y);
		}		

		icon = icons[ROW_TOP][COL_MIDDLE];
		if(icon != null)
		{
			int _y = y - icon.getIconHeight();
			icon.paintIcon(c, g, x, _y);
		}		

		icon = icons[ROW_TOP][COL_LEFT];
		if(icon != null)
		{
			int _x = x - icon.getIconWidth();
			int _y = y - icon.getIconHeight();
			icon.paintIcon(c, g, _x, _y);
		}					
		
		icon = icons[ROW_TOP][COL_RIGTH];
		if(icon != null)
		{
			int _x = x + getMaxWidthByCol(COL_MIDDLE);
			int _y = y - icon.getIconHeight();
			icon.paintIcon(c, g, _x, _y);
		}		

		icon = icons[ROW_BOTTON][COL_MIDDLE];
		if(icon != null)
		{
			int _y = y + getMaxHeightByRow(ROW_MIDDLE);
			icon.paintIcon(c, g, x, _y);
		}		

		icon = icons[ROW_BOTTON][COL_LEFT];
		if(icon != null)
		{
			int _x = x - icon.getIconWidth();
			int _y = y + getMaxHeightByRow(ROW_MIDDLE);
			icon.paintIcon(c, g, _x, _y);
		}					
		
		icon = icons[ROW_BOTTON][COL_RIGTH];
		if(icon != null)
		{
			int _x = x + getMaxWidthByCol(COL_MIDDLE);
			int _y = y + getMaxHeightByRow(ROW_MIDDLE);
			icon.paintIcon(c, g, _x, _y);
		}
	}

	private int getMaxHeightByRow(int row)
	{
		int maxHeight = 0;
		for(int i = 0; i < 3; i++)
		{
			Icon icon = icons[row][i]; 
			if((icon != null) && (maxHeight < icon.getIconHeight()))
				maxHeight = icon.getIconHeight();
		}
		
		return maxHeight;
	}
	
	private int getMaxWidthByCol(int col)
	{
		int maxWidth = 0;
		for(int i = 0; i < 3; i++)
		{
			Icon icon = icons[i][col]; 
			if((icon != null) && (maxWidth < icon.getIconWidth()))
				maxWidth = icon.getIconWidth();
		}
		
		return maxWidth;
	}
}
