/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TSTDataPool.java,v 1.9 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.test.data;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TST Data Pool</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A DataPool is a grouping mechanism aimed at holding a set of Equivalence Classes themselves grouping a set of Instance Values.
 * 
 * A DataPool is referenced by TestSuite making use of it.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.test.data.TSTDataPool#getTestSuites <em>Test Suites</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.test.data.TSTDataPool#getEquivalenceClasses <em>Equivalence Classes</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.test.data.DataPackage#getTSTDataPool()
 * @model 
 * @generated
 */
public interface TSTDataPool extends EObject{
	/**
	 * Returns the value of the '<em><b>Test Suites</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFTestSuite}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Suites</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Test Suites</em>' reference list.
	 * @see org.eclipse.hyades.models.test.data.DataPackage#getTSTDataPool_TestSuites()
	 * @model type="org.eclipse.hyades.models.common.testprofile.TPFTestSuite"
	 * @generated
	 */
	EList getTestSuites();

	/**
	 * Returns the value of the '<em><b>Equivalence Classes</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.test.data.TSTEquivalenceClass}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.test.data.TSTEquivalenceClass#getDataPool <em>Data Pool</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Equivalence Classes</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Equivalence Classes</em>' containment reference list.
	 * @see org.eclipse.hyades.models.test.data.DataPackage#getTSTDataPool_EquivalenceClasses()
	 * @see org.eclipse.hyades.models.test.data.TSTEquivalenceClass#getDataPool
	 * @model type="org.eclipse.hyades.models.test.data.TSTEquivalenceClass" opposite="dataPool" containment="true"
	 * @generated
	 */
	EList getEquivalenceClasses();

} // TSTDataPool
