/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TSTEquivalenceClass.java,v 1.9 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.test.data;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TST Equivalence Class</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An Equivalence class is a grouping mechansim for a set of Instance Values related. The relationship between those Instance Values is generally that their outcome is the same from the standpoint of the TestCase where they are used.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.test.data.TSTEquivalenceClass#getDataPool <em>Data Pool</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.test.data.TSTEquivalenceClass#getInstanceValues <em>Instance Values</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.test.data.DataPackage#getTSTEquivalenceClass()
 * @model 
 * @generated
 */
public interface TSTEquivalenceClass extends EObject{
	/**
	 * Returns the value of the '<em><b>Data Pool</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.test.data.TSTDataPool#getEquivalenceClasses <em>Equivalence Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Data Pool</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Data Pool</em>' container reference.
	 * @see #setDataPool(TSTDataPool)
	 * @see org.eclipse.hyades.models.test.data.DataPackage#getTSTEquivalenceClass_DataPool()
	 * @see org.eclipse.hyades.models.test.data.TSTDataPool#getEquivalenceClasses
	 * @model opposite="equivalenceClasses" required="true"
	 * @generated
	 */
	TSTDataPool getDataPool();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.test.data.TSTEquivalenceClass#getDataPool <em>Data Pool</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Data Pool</em>' container reference.
	 * @see #getDataPool()
	 * @generated
	 */
	void setDataPool(TSTDataPool value);

	/**
	 * Returns the value of the '<em><b>Instance Values</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFInstanceValue}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instance Values</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instance Values</em>' containment reference list.
	 * @see org.eclipse.hyades.models.test.data.DataPackage#getTSTEquivalenceClass_InstanceValues()
	 * @model type="org.eclipse.hyades.models.common.testprofile.TPFInstanceValue" containment="true"
	 * @generated
	 */
	EList getInstanceValues();

} // TSTEquivalenceClass
