/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ContextInstanceTypeItemProvider.java,v 1.8 2005/02/16 22:20:35 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.configuration.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ContextInstanceTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	public final static String DESCRIPTION = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_DESCR");
	public final static String UNIQUE_ID = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_ID");
	public final static String MAXIMUM_IDLE = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_TIME");
	public final static String PAUSE_INTERVAL = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_PAUSEI");
	public final static String CONTINUOUS_OP = AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_CONT");
	public final static String ISO_LANG_CODE = AcadEditorPlugin.getPlugin().getString("STR_ISO_LANG_CODE");
	public final static String ISO_COUNTRY_CODE = AcadEditorPlugin.getPlugin().getString("STR_ISO_COUNTRY_CODE");
	public final static String CHARSET = AcadEditorPlugin.getPlugin().getString("STR_CHARSET");
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextInstanceTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addCharsetPropertyDescriptor(object);
			addContinuousOperationPropertyDescriptor(object);
			addDescriptionPropertyDescriptor(object);
			addIsoCountryCodePropertyDescriptor(object);
			addIsoLanguageCodePropertyDescriptor(object);
			addMaximumIdleTimePropertyDescriptor(object);
			addPauseIntervalPropertyDescriptor(object);
			addUniqueIDPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Charset feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addCharsetPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CHARSET"),
				 getString("_UI_PropertyDescriptor_description", "STR_CHARSET", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_Charset(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Continuous Operation feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addContinuousOperationPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_CONT"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_CONT", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_ContinuousOperation(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Description feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addDescriptionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_DESCR"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_DESCR", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_Description(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Iso Country Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIsoCountryCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ISO_COUNTRY_CODE"),
				 getString("_UI_PropertyDescriptor_description", "STR_ISO_COUNTRY_CODE", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_IsoCountryCode(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Iso Language Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIsoLanguageCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ISO_LANG_CODE"),
				 getString("_UI_PropertyDescriptor_description", "STR_ISO_LANG_CODE", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_IsoLanguageCode(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Maximum Idle Time feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addMaximumIdleTimePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_TIME"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_TIME", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_MaximumIdleTime(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Pause Interval feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addPauseIntervalPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_PAUSEI"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_PAUSEI", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_PauseInterval(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Unique ID feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUniqueIDPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_CONTEXTI_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_CONTEXTI_ID", "_UI_ContextInstanceType_type"),
				 ConfigurationPackage.eINSTANCE.getContextInstanceType_UniqueID(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor());
			childrenFeatures.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor());
			childrenFeatures.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Parser());
			childrenFeatures.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit());
			childrenFeatures.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter());
			childrenFeatures.add(ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter());
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}


	/**
	 * This returns ContextInstanceType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		
		if(object instanceof SensorConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_SENSOR);
		else if(object instanceof ExtractorType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_EXTRACTOR);	   
		else if(object instanceof FormatterType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_FORMATTER);
		else if(object instanceof ProcessUnitType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PROCESS_UNIT);
		else if(object instanceof OutputterConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_OUTPUTTER);
		else if(object instanceof ParserConfigType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_PARSER);
		   		   
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_CONTEXT_INSTANCE);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		ContextInstanceType contextInstanceType = (ContextInstanceType)object;
		
		String label = contextInstanceType.getUniqueID();
		return label == null || label.length() == 0 ?
			getString("_UI_ContextInstanceType_type") :
			getString("_UI_ContextInstanceType_type") + " [" + label + "]";
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ContextInstanceType.class)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		SensorConfigType sensor = SensorFactory.eINSTANCE.createSensorConfigType();
		PropertyType property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("directory");
		sensor.getProperty().add(property);
		property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("fileName");
		sensor.getProperty().add(property);
		sensor.setDescription("A single file sensor");
		sensor.setMaximumBlocking("5");
		sensor.setType(SensorType.SINGLE_FILE_SENSOR_LITERAL);
		
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor(),
				 sensor));

		ExtractorType extractor = ExtractorFactory.eINSTANCE.createExtractorType();
		extractor.setContainsLineBreaks(true);
		extractor.setContainsLineBreaks(false);
		extractor.setIncludeEndPattern(true);
		extractor.setIncludeEndPattern(false);
		extractor.setIncludeStartPattern(true);
		extractor.setIncludeStartPattern(false);
		extractor.setReplaceLineBreaks(true);
		extractor.setReplaceLineBreaks(false);		 
		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Extractor(),
				 extractor));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Parser(),
				 ParserFactory.eINSTANCE.createParserConfigType()));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit(),
				 UnitFactory.eINSTANCE.createProcessUnitType()));

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Formatter(),
				 FormatterFactory.eINSTANCE.createFormatterType()));

		OutputterConfigType outputterConfigType = OutputterFactory.eINSTANCE.createOutputterConfigType();
		property = UnitFactory.eINSTANCE.createPropertyType();
		property.setPropertyName("agentName");
		property.setPropertyValue("Default Logging Agent");
		outputterConfigType.getProperty().add(property);
		outputterConfigType.setDescription("Logging Agent Outputter");
		outputterConfigType.setType(OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL);

		newChildDescriptors.add
			(createChildParameter
				(ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter(),
				 outputterConfigType));
	}

	/**
	 * This returns the label text for {@link org.eclipse.emf.edit.command.CreateChildCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getCreateChildText(Object owner, Object feature, Object child, Collection selection) {
		boolean qualify = false;
//			feature == ConfigurationPackage.eINSTANCE.getContextInstanceType_Sensor() ||
//			feature == ConfigurationPackage.eINSTANCE.getContextInstanceType_ProcessUnit() ||
//			feature == ConfigurationPackage.eINSTANCE.getContextInstanceType_Outputter();
		return getString(
			qualify ? "_UI_CreateChild_text2" : "_UI_CreateChild_text",
			new Object[] { getTypeText(child), getFeatureText(feature), getTypeText(owner) });
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
}
