/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OutputterItemProviderAdapterFactory.java,v 1.5 2005/02/16 22:20:35 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.outputter.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.util.OutputterAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class OutputterItemProviderAdapterFactory extends OutputterAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OutputterItemProviderAdapterFactory() {
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterTypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoggingAgentOutputterTypeTypeItemProvider loggingAgentOutputterTypeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterTypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createLoggingAgentOutputterTypeTypeAdapter() {
		if (loggingAgentOutputterTypeTypeItemProvider == null) {
			loggingAgentOutputterTypeTypeItemProvider = new LoggingAgentOutputterTypeTypeItemProvider(this);
		}

		return loggingAgentOutputterTypeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterTypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NotificationOutputterTypeTypeItemProvider notificationOutputterTypeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterTypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNotificationOutputterTypeTypeAdapter() {
		if (notificationOutputterTypeTypeItemProvider == null) {
			notificationOutputterTypeTypeItemProvider = new NotificationOutputterTypeTypeItemProvider(this);
		}

		return notificationOutputterTypeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OutputterConfigTypeItemProvider outputterConfigTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createOutputterConfigTypeAdapter() {
		if (outputterConfigTypeItemProvider == null) {
			outputterConfigTypeItemProvider = new OutputterConfigTypeItemProvider(this);
		}

		return outputterConfigTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterTypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleFileOutputterTypeTypeItemProvider singleFileOutputterTypeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterTypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSingleFileOutputterTypeTypeAdapter() {
		if (singleFileOutputterTypeTypeItemProvider == null) {
			singleFileOutputterTypeTypeItemProvider = new SingleFileOutputterTypeTypeItemProvider(this);
		}

		return singleFileOutputterTypeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterTypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StandardOutOutputterTypeTypeItemProvider standardOutOutputterTypeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterTypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStandardOutOutputterTypeTypeAdapter() {
		if (standardOutOutputterTypeTypeItemProvider == null) {
			standardOutOutputterTypeTypeItemProvider = new StandardOutOutputterTypeTypeItemProvider(this);
		}

		return standardOutOutputterTypeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.DocumentRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentRootItemProvider documentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.DocumentRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDocumentRootAdapter() {
		if (documentRootItemProvider == null) {
			documentRootItemProvider = new DocumentRootItemProvider(this);
		}

		return documentRootItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

}
