/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DetailsContent.java,v 1.5 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.hyades.logging.adapter.impl.Extractor;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ComponentConfigSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ComponentSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ContextInstanceSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ContextSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ExtractorSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.FormatterSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.InfoSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.OutputterSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ParserSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ProcessUnitSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.PropertySection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleAttributeSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleElementSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleSection;
import org.eclipse.hyades.logging.adapter.ui.internal.util.SensorSection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
public class DetailsContent extends Composite {
	protected EditingDomain editingDomain;
	protected StackLayout detailsLayout;
	protected Composite details;
	protected RuleBuilderWidgetFactory widgetFactory;
	protected ConfigurationItemProviderAdapterFactory factory;
	protected ComponentConfigSection compSection;
	protected ContextInstanceSection contextInstanceSection;
	protected ExtractorSection extractorSection;
	protected ParserSection parserSection;
	protected RuleSection ruleSection;
	protected ProcessUnitSection unitSection;
	protected SensorSection sensorSection;
	protected PropertySection propertySection;
	protected OutputterSection outputterSection;
	protected InfoSection infoDetails;
	protected ContextSection contextSection;
	protected ComponentSection componentSection;
	protected RuleAttributeSection attrSection;
	protected RuleElementSection elemSection;
	protected FormatterSection formatterSection;
	/**
	 * Constructor for DetailsContent.
	 */
	public DetailsContent(RuleBuilderWidgetFactory widgetFactory, EditingDomain editingDomain, ConfigurationItemProviderAdapterFactory factory, Composite composite, int style) {
		super(composite, style);
		this.widgetFactory = widgetFactory;
		this.factory = factory;
		this.editingDomain = editingDomain;
	}
	public Composite createContent() {
		detailsLayout = new StackLayout();
		this.setLayout(detailsLayout);
		GridData detailsGrid = new GridData(GridData.FILL_BOTH);
		detailsGrid.horizontalIndent = 10;
		this.setLayoutData(detailsGrid);
		compSection = new ComponentConfigSection(widgetFactory, this, SWT.NONE);
		contextInstanceSection = new ContextInstanceSection(widgetFactory, this, SWT.NONE);
		extractorSection = new ExtractorSection(widgetFactory, this, SWT.NONE);
		parserSection = new ParserSection(widgetFactory, this, SWT.NONE);
		ruleSection = new RuleSection(widgetFactory, this, SWT.NONE);
		unitSection = new ProcessUnitSection(widgetFactory, this, SWT.NONE);
		sensorSection = new SensorSection(widgetFactory, this, SWT.NONE);
		outputterSection = new OutputterSection(widgetFactory, this, SWT.NONE);
		propertySection = new PropertySection(widgetFactory, this, SWT.NONE);
		infoDetails = new InfoSection(widgetFactory, this, SWT.NONE);
		contextSection = new ContextSection(widgetFactory, editingDomain, this, SWT.NONE);
		componentSection = new ComponentSection(widgetFactory, editingDomain, this, SWT.NONE);
		attrSection = new RuleAttributeSection(widgetFactory, this, SWT.NONE);
		elemSection = new RuleElementSection(widgetFactory, this, SWT.NONE);
		formatterSection = new FormatterSection(widgetFactory, this, SWT.NONE);
		hideDetails();
		return details;
	}
	/**
	 * @param data
	 */
	public void showDetailsFor(EObject data) {
		if (data instanceof ConfigurationType)
			showDetail(compSection, data);
		else if (data instanceof ContextType)
			showDetail(contextSection, data);
		else if (data instanceof ContextInstanceType)
			showDetail(contextInstanceSection, data);
		else if (data instanceof SensorConfigType)
			showDetail(sensorSection, data);
		//		else if(data instanceof SingleFileSensorType)
		//			showDetail(singleFileSensorSection, data);
		//		else if(data instanceof StaticParserSensorType)
		//			showDetail(staticParserSection, data);
		else if (data instanceof ExtractorType)
			showDetail(extractorSection, data);
		else if (data instanceof ParserConfigType)
			showDetail(parserSection, data);
		else if (data instanceof SubstitutionRuleType)
			showDetail(ruleSection, data);
		else if (data instanceof OutputterConfigType)
			showDetail(outputterSection, data);
		//		else if(data instanceof SingleFileOutputterTypeType)
		//			showDetail(singleFileOutputterSection, data);
		//		else if(data instanceof LoggingAgentOutputterTypeType)
		//			showDetail(logOutputterSection, data);
		else if (data instanceof Component)
			showDetail(componentSection, data);
		else if (data instanceof RuleAttributeType)
			showDetail(attrSection, data);
		else if (data instanceof RuleElementType)
			showDetail(elemSection, data);
		else if (data instanceof FormatterType)
			showDetail(formatterSection, data);
		else if (data instanceof PropertyType)
			showDetail(propertySection, data);
		else if(data instanceof ProcessUnitType)
			showDetail(unitSection, data);  
		else
			showDetail(infoDetails, data);
	}
	public void setFocusFor(Object object) {
		if (object instanceof ConfigurationType)
			compSection.setFocusToText();
		else if (object instanceof ContextType)
			contextSection.setFocusToText();
		else if (object instanceof ContextInstanceType)
			contextInstanceSection.setFocusToText();
		else if (object instanceof SensorConfigType)
			sensorSection.setFocusToText();
		//		else if(object instanceof SingleFileSensorType)
		//			singleFileSensorSection.setFocusToText();
		//		else if(object instanceof StaticParserSensorType)
		//			staticParserSection.setFocusToText();
		else if (object instanceof Extractor)
			extractorSection.setFocusToText();
		else if (object instanceof ParserConfigType)
			parserSection.setFocusToText();
		else if (object instanceof SubstitutionRuleType)
			ruleSection.setFocusToText();
		else if (object instanceof ProcessUnitType)
			unitSection.setFocusToText();
		else if (object instanceof OutputterConfigType)
			outputterSection.setFocusToText();
		//		else if(object instanceof SingleFileOutputterTypeType)
		//			 singleFileOutputterSection.setFocusToText();
		//		else if(object instanceof LoggingAgentOutputterTypeType)
		//			 logOutputterSection.setFocusToText();
		else if (object instanceof Component)
			componentSection.setFocusToText();
		else if (object instanceof RuleAttributeType)
			attrSection.setFocusToText();
		else if (object instanceof RuleElementType)
			elemSection.setFocusToText();
		else if (object instanceof FormatterType)
			formatterSection.setFocusToText();
		else if (object instanceof PropertyType)
			propertySection.setFocusToText();
	}
	private void hideDetails() {
		compSection.setVisible(false);
		contextInstanceSection.setVisible(false);
		sensorSection.setVisible(false);
		extractorSection.setVisible(false);
		parserSection.setVisible(false);
		ruleSection.setVisible(false);
		unitSection.setVisible(false);
		outputterSection.setVisible(false);
		infoDetails.setVisible(false);
		contextSection.setVisible(false);
		componentSection.setVisible(false);
		attrSection.setVisible(false);
		elemSection.setVisible(false);
		formatterSection.setVisible(false);
		propertySection.setVisible(false);
	}
	private void showDetail(Control detail, EObject data) {
		((IDetails) detail).display(data);
		detailsLayout.topControl = detail;
		layout();
	}
	public void dispose() {
		factory = null;
		widgetFactory = null;
		editingDomain = null;
		if (infoDetails != null)
			infoDetails.dispose();
		if (ruleSection != null)
			ruleSection.dispose();
		if (compSection != null)
			compSection.dispose();
		if (contextInstanceSection != null)
			contextInstanceSection.dispose();
		if (extractorSection != null)
			extractorSection.dispose();
		if (unitSection != null)
			unitSection.dispose();
		if (sensorSection != null)
			sensorSection.dispose();
		if (outputterSection != null)
			outputterSection.dispose();
		if (parserSection != null)
			parserSection.dispose();
		if (contextSection != null)
			contextSection.dispose();
		if (componentSection != null)
			componentSection.dispose();
		if (attrSection != null)
			attrSection.dispose();
		if (elemSection != null)
			elemSection.dispose();
		if (formatterSection != null)
			formatterSection.dispose();
		if (propertySection != null)
			propertySection.dispose();
	}
}
