/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AcadPerspective.java,v 1.5 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class AcadPerspective implements IPerspectiveFactory {
	
	public static final String ID_ACAD_PERSPECTIVE = "org.eclipse.hyades.logging.adapter.ui.perspective";	
	public static final String ID_LOGVIEW = "org.eclipse.hyades.logging.adapter.ui.views.logview";
	public static final String ID_RESULTVIEW = "org.eclipse.hyades.logging.adapter.ui.views.resultview";
	public static final String ID_CONTENTVIEW = "org.eclipse.hyades.logging.adapter.ui.views.contentview";
	
	/**
	 * Constructor for AcadPerspective
	 */
	public AcadPerspective() {
		super();
		
	}

	/**
	 * @see IPerspectiveFactory#createInitialLayout(IPageLayout)
	 */
	public void createInitialLayout(IPageLayout layout) {

        defineLayout(layout);		
		defineActions(layout);
		
 	}
 	
	/**
	 * Defines the initial actions for a page.  
	 */
	public void defineActions(IPageLayout layout) {
		// Add "new wizards".
		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");//$NON-NLS-1$
		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");//$NON-NLS-1$

		// Add "show views".
		layout.addShowViewShortcut(ID_RESULTVIEW);
		layout.addShowViewShortcut(ID_CONTENTVIEW);		
		layout.addShowViewShortcut(ID_LOGVIEW);
	
		layout.addActionSet(IPageLayout.ID_NAVIGATE_ACTION_SET);
	}
	
	/**
	 * Defines the initial layout for a page.  
	 */
	public void defineLayout(IPageLayout layout) {
		
		// Get the editor area.
		String editorArea = layout.getEditorArea();
		 
		// Left: Resource Navigator view
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, 0.25f,
			editorArea);
		topLeft.addView(IPageLayout.ID_RES_NAV);
		
		IFolderLayout bottom = layout.createFolder("bottom", IPageLayout.BOTTOM, 0.50f,
			editorArea);
		bottom.addView(ID_LOGVIEW);

		IFolderLayout bottomLeft = layout.createFolder("bottomLeft", IPageLayout.RIGHT, 0.50f,
			ID_LOGVIEW);
		bottomLeft.addView(ID_RESULTVIEW);
		bottomLeft.addView(ID_CONTENTVIEW);
		bottomLeft.addView(IPageLayout.ID_PROBLEM_VIEW);
		
	}	
 	
}

