/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ParserSection.java,v 1.4 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserConfigTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ParserSection extends Composite
								implements IDetails, ModifyListener
								           , INotifyChangedListener
{
	protected Text nameText;			
	protected Label uniqueId;
	
	protected Text indexText;	
	protected Text designationText;		
	
	protected ParserConfigType currentSelection;
	
    protected boolean isDisplaying = false;
    protected ParserConfigTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory;
	
	
	public ParserSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new ParserItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESCR"), SWT.NONE);	
		nameText = factory.createText(this, "", SWT.NONE);
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_SEPTOKEN"), SWT.NONE);	
		indexText = factory.createText(this, "");
		indexText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESTOKEN"), SWT.NONE);	
		designationText = factory.createText(this, "");
		designationText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		
		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		nameText.addModifyListener(this);
		indexText.addModifyListener(this);
		designationText.addModifyListener(this);
		
		itemProvider = (ParserConfigTypeItemProvider)itemFactory.createParserConfigTypeAdapter();
		itemProvider.addListener(this);
	}
	
	public void setFocusToText(){
	        nameText.setFocus();
	        nameText.selectAll();
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
		currentSelection = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
           
		if(nameText.isFocusControl() || uniqueId.isFocusControl()
		   || indexText.isFocusControl()|| designationText.isFocusControl())
		   
		  return;
        
		currentSelection = (ParserConfigType)object;
		isDisplaying = true;
			
		nameText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		uniqueId.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		indexText.setText(currentSelection.getSeparatorToken()==null?"":currentSelection.getSeparatorToken());
		designationText.setText(currentSelection.getDesignationToken()==null?"":currentSelection.getDesignationToken());

		BusyIndicator.showWhile(Display.getCurrent(), new Runnable() {
			public void run() {
				AcadGuiModelManager.setCurrentModel((ContextInstanceType)currentSelection.eContainer());
		
			}
		});

     	
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

		this.currentSelection = (ParserConfigType)currentSelection;
		
		this.currentSelection.setDescription(nameText.getText());
		this.currentSelection.setSeparatorToken(indexText.getText());
		this.currentSelection.setDesignationToken(designationText.getText());
		
		return false;

	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == indexText)
		{
			String text = indexText.getText();
			if(!text.equals(currentSelection.getSeparatorToken()))
			{
				if(text.length() == 0 && currentSelection.getSeparatorToken() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ParserConfigTypeItemProvider.SEPARATOR);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == nameText)
		{
			String text = nameText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ParserConfigTypeItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == designationText)
		{
			String text = designationText.getText();
			if(!text.equals(currentSelection.getDesignationToken()))
			{
				if(text.length() == 0 && currentSelection.getDesignationToken() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ParserConfigTypeItemProvider.DESIGNATION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		
	}

}
