/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestContextListener.java,v 1.13 2005/03/30 15:20:43 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.hyades.logging.adapter.*;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.*;
import org.eclipse.swt.widgets.Display;

public class TestContextListener implements IContextListener {
	
	/* Record indices */
	private int extractorIndex = 0;
	private int formatterIndex = 0;
	
	private boolean firstRecord=true;
	
	protected ContextInstanceType context;
	
	private ResultQueue queue=null;
	
	private String staticParserName="org.eclipse.hyades.logging.adapter.config.sensors.StaticParserSensor";
	
	public TestContextListener()
	{
		super();
	}

	/**
	 * @see org.eclipse.hyades.logging.adaptor.IContextListener#preProcessEventItems(org.eclipse.hyades.logging.adaptor.IComponent, java.lang.Object[])
	 */
	public void preProcessEventItems(IComponent component, Object[] msgs) {
	}

	/**
	 * @see org.eclipse.hyades.logging.adaptor.IContextListener#postProcessEventItems(org.eclipse.hyades.logging.adaptor.IComponent, java.lang.Object[])
	 */
	public void postProcessEventItems(IComponent component, Object[] results) {
		
		final AcadGuiModel model = AcadGuiModelManager.getModel(context);
		if(model==null) {
			return;
		}
		else {
			if(queue==null) {
				queue=model.getResultQueue();
			}
		}
		if(component.getClass().getName().equals(staticParserName)) {
			if(results != null && model != null){
				for(int idx=0; idx<results.length; idx++){
					if(results[idx] != null && ++extractorIndex >= model.getStartRecord()){
						MessageString msg = new MessageString();
						msg.setValue(AcadEditorPlugin.getPlugin().getString("STR_STATIC_PARSER_EXTRACTOR_MSG"));
						queue.insertExtractorResult(msg);
						if(firstRecord) {
								Display.getDefault().asyncExec(new Runnable() {
									public void run() {
										LogView log=LogView.getLogView(false);
										if(log!=null) {
											log.enableActions();
										}
									}
								});
								firstRecord=false;
						}
					}
					if(results[idx] != null && ++formatterIndex >= model.getStartRecord())
						queue.insertFormatterResult(results[idx]);
				}
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						model.updateTemplateLog();								
					}
				});
			}
			//return;
		}

		if(component instanceof ISensor) {
			if(results != null) {
				StringBuffer buffer = new StringBuffer();
				int resultCnt = 0;
				for(int idx=0; idx<results.length; idx++)
					if(results[idx] != null) {
						buffer.append(results[idx]).append("\n");
						resultCnt++;
					}
				
				if(model != null) {		
					model.setLogContent(model.getLogContent() + buffer.toString(), resultCnt);
				}
			}
		}
		/* Each of the messages returned from the extractor need to be placed into the queue
		 * 
		 */
        else if(component instanceof IExtractor) {
			if(results != null) {
				if(model!=null) {
					for(int idx=0; idx<results.length; idx++) {
						
						/* Check if we have made it to the starting record index */
						if(results[idx] != null && ++extractorIndex >= model.getStartRecord()) {
	 							queue.insertExtractorResult(results[idx]);
						}
						
					}
					
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							model.updateTemplateLog();								
						}
					});
					
				}
			}
        }
		/* 
		 * Process Parser output
		 */
        else if(component instanceof IParser) {
        	/* bugzilla 89285 - add capability to dump extractor output to view if there is no
        	 * parser/formatter output.
        	 * 
        	 * If there are no results from the Parser then add the extractor output to the queue
        	 */
			if(results == null && model != null) {
				queue.forceExtractorResult();
				
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						model.updateTemplateLog();								
					}
				});
			}
			/* Do not care if there are results from the Parser */
        }
		else if(component instanceof IFormatter) {
			/* This is a result from the formatter.  Add it to the result queue */
			if(results != null) {
				if(model!=null) {
					for(int idx=0; idx<results.length; idx++) {
						
  				    /* Check if we have made it to the starting record index */
					if(results[idx] != null && ++formatterIndex >= model.getStartRecord()) {
							queue.insertFormatterResult(results[idx]);

							/* Bug 77187: Moved the following from the extractor block above
							 * because an event entry is not complete without the formatter
							 * output. This problem is most severe under the multi-threaded
							 * context. 
							 */

							/* RKD:  There is ap otential problem here where the UI does not get updated
 							 * until the entire amount of records is put in the queue. If the record count
 							 * is greater then the queue length then the buttons may not be enabled to
 							 * allow the user to start flushing the queue.  This results in a deadlock
 							 * during the call to add an entry to the queue.  To circumvent this we are going
 							 * to make sure the buttons are enabled as soon as we add our first event to
 							 * the queue.
 							 */
							if(firstRecord) {
 								Display.getDefault().asyncExec(new Runnable() {
 									public void run() {
 										LogView log=LogView.getLogView(false);
 										if(log!=null) {
 											log.enableActions();
 										}
 									}
 								});
 								firstRecord=false;
 							}
						}
					}
				}
			}
		}
	}

	/**
	 * @see org.eclipse.hyades.logging.adaptor.IContextListener#getTargetContextUniqueIds()
	 */
	public String[] getTargetContextUniqueIds() {
		
		
		AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
		if(model == null || model.getContextInstance() == null)
		{
			context = null;
			return new String[] {};
			
		}		
		context = model.getContextInstance();
		model.setContextListener(this);
		
		return new String[] {context.getUniqueID()};
	}

	/**
	 * @return
	 */
	public ContextInstanceType getContext() {
		return context;
	}

	/**
	 * @param type
	 */
	public void setContext(ContextInstanceType type) {
		context = type;
	}	
}
