/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AcadGuiModel.java,v 1.15 2005/02/16 22:20:37 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.util.Iterator;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueue;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;
import org.eclipse.hyades.logging.adapter.ui.internal.util.TestContextListener;
import org.eclipse.hyades.logging.adapter.ui.preferences.AcadEditorPreferencePage;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;


public class AcadGuiModel 
{
	protected ContextInstanceType context;

	protected String logContent = "";
	protected long logContentCnt = 0;
		
	protected Adapter adaptor;
	protected TestContextListener contextListener;
	
	private ResultQueue resultQueue;
	private int resultQueueCursor;
	private int resultQueueBeginCount;
	
	private boolean cycling=false;
	protected int startRecord = 1;
	
	
	public AcadGuiModel() {
		resultQueue=new ResultQueue();
		resultQueue.setMaxSize(AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(AcadEditorPreferencePage.BUFFER_SIZE));
		resultQueueCursor=-1;
	}
	
	
    /**
     * 
     * @return
     */
	public ResultQueueEntry getFirstEvent() {
		
		ResultQueueEntry entry=(ResultQueueEntry)resultQueue.getFirstEntry();
		resultQueueCursor=0;
		return entry;		  
	}
	
	/**
	 * 
	 * @return
	 */
	public ResultQueueEntry getLastEvent() {
		ResultQueueEntry entry=(ResultQueueEntry)resultQueue.getLastEntry();
		resultQueueCursor=resultQueue.getSize()-1;
		return entry;	  
	}
	

	/**
	 * 
	 * @return
	 */
	public ResultQueueEntry getNextEvent() {
		ResultQueueEntry entry=null;

		if(resultQueueCursor==resultQueue.getMaxSize()-1) {
			Object firstEvent = resultQueue.remove();
			resultQueueBeginCount++;
			
//			while(resultQueue.get(resultQueueCursor)==null);
			
			entry=(ResultQueueEntry)resultQueue.get(resultQueueCursor);
			if (entry == null){
				resultQueue.undoRemove(firstEvent);
				resultQueueBeginCount--;
				resultQueueCursor++;
			}
		}
		else if(resultQueueCursor>=resultQueue.getSize()-1) {
			entry=(ResultQueueEntry)resultQueue.get(resultQueueCursor);
		}
		else {
			entry=(ResultQueueEntry)resultQueue.get(++resultQueueCursor);			
		}
	
		return entry;

	}
	
	public boolean hasNext() {
		return getEventCount() > 0 && resultQueueCursor<resultQueue.getSize();	
	}
	
	public boolean hasPrevious() {
		return getEventCount() > 0 && resultQueueCursor>0;	
	}
	
	/**
	 * 
	 * @return
	 */
	public ResultQueueEntry getPreviousEvent() {
		ResultQueueEntry entry=null;
		if(resultQueueCursor>0) {
			entry=(ResultQueueEntry)resultQueue.get(--resultQueueCursor);
		}
		else {
			entry=(ResultQueueEntry)resultQueue.get(resultQueueCursor);
		}
		return entry;			  
	}


	public void loadTemplateFile()
	{
		BusyIndicator.showWhile(Display.getCurrent(), new Runnable() {
			public void run() {	
				try {
					cycling=true;
					
					resetValues();
				
		
				  /**
				   * try to load rawLogFileName, return false if it fails
				   */
				  SensorConfigType sensor = AcadGuiModelManager.getLogForConfiguration(AcadGuiModel.this);
//				  if(sensor == null || sensor.getType() != SensorType.SINGLE_FILE_SENSOR_LITERAL
//				     || sensor.getSingleFileSensor() == null)
				  if(sensor == null || getProperty(sensor,"fileName")==null)
				  {
					 updateTestShow();
					 return;				  	
				  }
				  
				  String path = context.eResource().getURI().path();
				  if(path != null)
				  {
				  	if(path.startsWith("/resource"))
				  	  path = path.substring(10);
				  	  
					IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(path));
					if(res != null || res.exists())
					   path = res.getLocation().toOSString();
					   
				  }
				  
				  if(adaptor != null) {
				  	  /* First we flush the queue and then cleanup our
				  	   * reference to it so that when we tell the adaptor
				  	   * to stop and it flushes we are OK.
				  	   */
				  	  adaptor.hardStop();
					  resultQueue.flush();
					  resultQueue=null;
					  resultQueueBeginCount=0;
					  resultQueueCursor=-1;
					  
					  
					  resultQueue=new ResultQueue();
					  resultQueue.setMaxSize(AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(AcadEditorPreferencePage.BUFFER_SIZE));
					  LogView.getLogView(true).setContent("");
					  ResultView.getResultView(true).setResult("");
					  setLogContent("", 0);
				  } else {
					resultQueue.setMaxSize(AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(AcadEditorPreferencePage.BUFFER_SIZE));
				  }
				   
				  try {
					  adaptor = new Adapter();
					  adaptor.setComponentConfigPath(path);
					  adaptor.setContextConfigPath(path);
					  adaptor.start(true, true);
				  }
				  catch(AdapterException e) {
				  	/* A fatal error has occurred and the Adapter cannot be started. */
				  	MessageDialog.openError(
				  	      Display.getCurrent().getActiveShell(),AcadEditorPlugin.getDefault().getString("STR_CONFIGURATION_FATAL_ERROR"), e.getLocalizedMessage()==null?AcadEditorPlugin.getDefault().getString("STR_CONFIGURATION_UNKNOWN_ERROR"):e.getLocalizedMessage());
				  	
				  }
			
				}
				catch(Exception exc)
				{
					IStatus status = new Status(IStatus.ERROR, AcadEditorPlugin.getDefault().getPluginId()
						  , 0, exc.getMessage(), exc);
					AcadEditorPlugin.getDefault().logMessage(status, true);								
				}
				finally {
					cycling=false;
				}
				
				updateTestShow();
			}
		});

	}

	/**
	 * @param sensor
	 * @param string
	 * @return
	 */
	public static PropertyType getProperty(SensorConfigType sensor, String string) {
		if(sensor==null || string==null)
			return null;
		for (Iterator iter = sensor.getProperty().iterator(); iter.hasNext(); ) {
			PropertyType element = (PropertyType) iter.next();
			if(string.equals(element.getPropertyName()))
			{
				return element;
			}
		}
		return null;
	}


	public void updateTestShow()
	{
		LogView logView = LogView.getLogView(true);
				
		if(logView != null)
		{		
            if(getEventCount() > 0)		
            {
				ResultView resultView = ResultView.getResultView(false);
				if(resultView != null)
				  resultView.reset();
				ContentView contentView = ContentView.getContentView(false);
				if(contentView != null)
				{
					contentView.showLog(); 
					contentView.set_Title();
				}
            	
				logView.showFirstEvent();				
            }
			else
			{
				logView.reset();
				logView.enableActions();
				logView.set_Title();
			}
		}
	}
	
	public void updateResult() {
		if(cycling) {
			return;
		}
		ResultView resultsView=ResultView.getResultView(true);
		if(resultsView!=null && resultQueueCursor>=0)  {
			ISerializableAsXml event=(ISerializableAsXml)((ResultQueueEntry)resultQueue.get(resultQueueCursor)).formatterOutput;
			if(event!=null) {
				resultsView.setResult(event.externalizeCanonicalXmlString());
			}
		}
		
	}
	
	public void updateTemplateLog()
	{
		if(cycling) {
			return;
		}
		LogView resultView = LogView.getLogView(true);
		if(resultView != null) 
		{
			resultView.set_Title();
			resultView.enableActions();

		}
		
	}
	
	
	public void updateLogContent() {
		if(cycling) {
			return;
		}
		ContentView resultView = ContentView.getContentView(false);
		if(resultView != null && resultQueueCursor<0) {
			resultView.setContent(logContent);
		}
	}

	/**
	 * @return
	 */
	public long getCurrentCount() {
		return resultQueueCursor+resultQueueBeginCount;
	}

	/**
	 * @return
	 */
	public long getEventCount() {
		return resultQueueBeginCount+resultQueue.getSize();
	}
	
	public long getLogContentCount() {
		return logContentCnt;
	}

    public void dispose()  { 
    	logContent = "";  
		resultQueueBeginCount=0;
		resultQueueCursor=-1;
    	resultQueue.flush();
    	resultQueue=null;
    	context = null;
    	adaptor = null; 	
    	
    	if(contextListener != null)
    	  contextListener.setContext(null);
    	  
    	contextListener = null;  
    	
//		LogView logView = LogView.getLogView(false);				
//		if(logView != null)
//		  logView.reset();
    }
    
    public void resetValues() {
    	logContent = "";
    	logContentCnt = 0;
    }
    
	/**
	 * @return
	 */
	public ContextInstanceType getContextInstance() {
		return context;
	}

	/**
	 * @param id
	 */
	public void setContextInstance(ContextInstanceType context) {
		this.context = context;
	}

	/**
	 * @return
	 */
	public String getLogContent() {
		return logContent;
	}

	/**
	 * @param string
	 */
	public void setLogContent(String string, int appended) {
		logContent = string;
		logContentCnt += appended;
	}

 
	/**
	 * @return
	 */
	public TestContextListener getContextListener() {
		return contextListener;
	}

	/**
	 * @param listener
	 */
	public void setContextListener(TestContextListener listener) {
		contextListener = listener;
	}
	
	public ResultQueue getResultQueue() {
		return resultQueue;
	}

	/**
	 * @return
	 */
	public int getResultQueueBeginCount() {
		return resultQueueBeginCount;
	}

	/**
	 * @return Returns the startRecord.
	 */
	public int getStartRecord() {
		return startRecord;
	}
	/**
	 * @param startRecord The startRecord to set.
	 */
	public void setStartRecord(int startRecord) {
		this.startRecord = startRecord;
	}
}
