package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataPoint.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * Representation of a Data Point
 * 
 * @version 1.4
 */
public class DataPoint {
    /**
     *  DataPoint type constant: actual data
     */
    public static final int ACTUAL = 0;

    /**
     *  DataPoint type constant: interpolated or fictitious data
     */
    public static final int HOLE = 1;
    
    // The actual input strings are stored so that we can display exactly the
    // way user wanted.
    private String value1String = null;
    private String value2String = null;
    private double value1 = 0.0;
    private double value2 = 0.0;
    private int type = ACTUAL;
    private String label = null;
    
    private String imageType = null;
    private String imageURI = null;
    private String imageCode = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    

    /**
     *  Constructor for one dimensional data
     */        
    public DataPoint(String value2String) {
        setValue2String(value2String);
    }
    
    /**
     *  Constructor for two dimensional data
     */        
    public DataPoint(String value1String, String value2String) {
        setValue1String(value1String);
        setValue2String(value2String);
    }
    

    /**
     *  Getter for Value1
     */
    public double getValue1() { return value1; }
    /**
     *  Getter for Value1 as a string
     */
    public String getValue1String() { return value1String; }
    /**
     *  Setter for Value1 as a string
     */
    public void setValue1String(String value1String) { 
        this.value1String = value1String; 
        value1 = Double.parseDouble(value1String);
    }
    
    /**
     *  Getter for Value2
     */
    public double getValue2() { return value2; }
    /**
     *  Getter for Value2 as a string
     */
    public String getValue2String() { return value2String; }
    /**
     *  Setter for Value2 as a string
     */
    public void setValue2String(String value2String) { 
        this.value2String = value2String; 
        value2 = Double.parseDouble(value2String);
    }
    
    
    /**
     *  Getter for Type
     */
    public int getType() { return type; }
    /**
     *  Setter for Type
     */
    public void setType(int type) { this.type = type; }
    
    /**
     *  Getter for Label
     */
    public String getLabel() { return label; }
    /**
     *  Setter for Label
     */
    public void setLabel(String label) { this.label = label; }
    
    /**
     *  Getter for Image Type
     */
    public String getImageType() { return imageType; }
    /**
     *  Setter for Image Type
     */
    public void setImageType(String imageType) { this.imageType = imageType; }
    
    /**
     *  Getter for Image URI
     */
    public String getImageURI() { return imageURI; }
    /**
     *  Setter for Image URI
     */
    public void setImageURI(String imageURI) { this.imageURI = imageURI; }
    
    /**
     *  Getter for Image Code
     */
    public String getImageCode() { return imageCode; }
    /**
     *  Setter for Image Code
     */
    public void setImageCode(String imageCode) { this.imageCode = imageCode; }
    
    /**
     *  Getter for Image Width
     */
    public int getImageWidth() { return imageWidth; }
    /**
     *  Setter for Image Width
     */
    public void setImageWidth(int imageWidth) { this.imageWidth = imageWidth; }
    
    /**
     *  Getter for Image Height
     */
    public int getImageHeight() { return imageHeight; }
    /**
     *  Setter for Image Height
     */
    public void setImageHeight(int imageHeight) { this.imageHeight = imageHeight; }

    /**
     *  Get the label if it is set, otherwise format value2 according to the locale specified in the given GraphicAttributes
     *  @param attrs the GraphicAttributes that contains the current locale
     *  @return the label for display in the UI
     */
    public String getDisplayLabel(GraphicAttributes attrs) {
    	String s = getLabel();
    	if (s == null) {
    		s = attrs.formatNumber(getValue2());
    	}
    	return s;
	}

}
