/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteType2.java,v 1.6 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.sample.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.PartInitException;

import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationMapping;

/**
 * This is just a sample.  It is not a good practise to use classes from 
 * internal packages.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestSuiteType2 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteType2
	 */
	public TestSuiteType2()
	{
		super();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesGenericTestNewWizard#getType()
	 */
	protected String getType()
	{
		return "testSuiteType2";
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle("Location and file name");
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle("Attributes");
		addPage(getAttributeWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) throws PartInitException
	{
		IAssociationMapping mapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		mapping.setDefaultAssociationDescriptor(getType(), mapping.getAssociationDescriptor(getType(), "EditorExtension2"));
		
		super.openEditor(file);
	}	
}
