package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IWidgetListener.java,v 1.5 2005/02/16 22:20:55 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Map;

import org.eclipse.swt.widgets.Event;

public interface IWidgetListener 
{

	/**
	 * Takes an action based on the event passed as a parameter
	 * 
	 * @param event - The event that has been selected
	 */
	public void takeAction (Event event);
	
	
	/**
	 * This method is called once to store a reference to all existing
	 * widgets.
	 *
	 * @param widgets - A map of all the existing widget
	 */
	public void storeWidgets (Map widgets);
}
