/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: InProcessStrategy.java,v 1.2 2005/05/17 03:49:04 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.automation.client.strategies;

import java.lang.reflect.Method;

import org.eclipse.hyades.automation.core.Service;

/**
 * The in-process strategy, launches from within the same process as the caller,
 * currently this strategy is unsupported and untested in this release
 * 
 * @author Scott E. Schneider
 */
class InProcessStrategy extends AbstractExecutionStrategy {

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.automation.core.Service.Executable#execute(org.eclipse.hyades.automation.core.Service)
     */
    public Object execute(Service service) {
        System.out.println(service + " to be run in-process!");
        try {
            Class eclipseStarter = Class.forName("org.eclipse.core.runtime.adaptor.EclipseStarter");
            System.out.println(eclipseStarter);
            Method method = eclipseStarter.getMethod("run", new Class[] { String[].class, Runnable.class });
            System.out.println(method);
            Object returnValue = method.invoke(eclipseStarter, new Object[] { new String[] {}, null });
            System.out.println(returnValue);
            return returnValue;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}