/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestJavaImages.java,v 1.6 2005/02/16 22:21:44 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Test Java plugin.
 *  
 * @author marcelop
 * @since 0.3.0
 */
public class TestJavaImages
extends ImageManager
{
	/**
	 * TestJavaImages' singleton.
	 */
	public static final TestJavaImages INSTANCE = new TestJavaImages();
	
	/*
	 * Available cached Images in the Java plugin image registry.
	 */
	public static final String IMG_WIZBAN_NEW_JUNIT_TESTSUITE 		= "newjunit_wiz.gif";
	public static final String IMG_WIZBAN_NEW_JUNIT_TESTCASE 		= "newtest_wiz.gif";
	
	public static final String IMG_JUNIT_TEST_SUITE 				= "tsuite.gif";
	public static final String IMG_JUNIT_TEST_CASE 				    = "test.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_NEW_JUNIT_TESTSUITE);
		add(T_WIZBAN, IMG_WIZBAN_NEW_JUNIT_TESTCASE);

		add(T_OBJ, IMG_JUNIT_TEST_SUITE);
		add(T_OBJ, IMG_JUNIT_TEST_CASE);
	}	
}
