/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenSuiteMethod.java,v 1.2 2005/04/22 14:51:08 bjiang Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.java.internal.codegen;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.internal.codegen.Helper;

class GenSuiteMethod
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "\t\t" + NL;
  protected final String TEXT_2 = NL + "\t/**" + NL + "\t * Returns the JUnit test suite that implements the <b>";
  protected final String TEXT_3 = "</b>" + NL + "\t * definition." + NL + "\t */" + NL + "\tpublic static Test suite()" + NL + "\t{";
  protected final String TEXT_4 = "\t\t";
  protected final String TEXT_5 = " ";
  protected final String TEXT_6 = " = new ";
  protected final String TEXT_7 = "(\"";
  protected final String TEXT_8 = "\");" + NL + "\t\t";
  protected final String TEXT_9 = ".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"";
  protected final String TEXT_10 = "\");" + NL + "\t\t";
  protected final String TEXT_11 = NL + "        ";
  protected final String TEXT_12 = NL + NL + "\t\treturn ";
  protected final String TEXT_13 = ";" + NL + "\t}" + NL + "\t" + NL;

	public String generate(ITestSuite testSuite, final Helper helper)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	class InvocationGenerator
	{
		private String hyadesTestSuiteClassName;
		
		public InvocationGenerator(String hyadesTestSuiteClassName)
		{
			this.hyadesTestSuiteClassName = hyadesTestSuiteClassName;
		}
		
		public StringBuffer generate(String owner, List actions)
		{
			StringBuffer code = new StringBuffer();
			StringBuffer sb = new StringBuffer();
			for(Iterator i=actions.iterator(); i.hasNext();)
			{
				IAction action = (IAction)i.next();
				
				if(action instanceof ITestInvocation)
					sb = generate(owner, (ITestInvocation)action);
				else if(action instanceof ILoop)
					sb = generate(owner, (ILoop)action);
				else
					continue;

				if (sb == null)
				{ //error condition
					//code.append(NL).append("//ERROR: No definition found for test element: ").append(action.getName()).append(NL).append(NL);
					continue;	
				}					

				if(sb.length() == 0)
					continue;
				
				if(code.length() > 0)
					code.append(NL).append(NL);
				code.append(sb.toString());
			}

			return code;
		}
		
		private StringBuffer generate(String owner, ITestInvocation testInvocation)
		{
			StringBuffer sb = new StringBuffer(owner).append(".addTest(");
			ITest invokedTest = testInvocation.getInvokedTest();
			if(invokedTest == null)
				return null;
				
			if(invokedTest instanceof ITestSuite)
			{
				sb.append("((").append(hyadesTestSuiteClassName).append(")").append(helper.getImportedName(invokedTest.getImplementor().getResource())).append(".suite())");
			}
			else
			{
				ITestCase testCase = (ITestCase)invokedTest;
				String identifier = testCase.getImplementor().getResource();
				if(identifier == null)
					identifier = helper.retrieveIdentifierName(testCase, "METHOD");

				sb.append("new ").append(helper.getImportedName(testCase.getOwner().getImplementor().getResource())).append("(\"").append(identifier).append("\")");
				sb.append(".setId(\"").append(invokedTest.getId()).append("\")");
			}
			sb.append(".setTestInvocationId(\"").append(testInvocation.getId()).append("\")");			
			if(!testInvocation.isSynchronous())
				sb.append(".setSynchronous(false)");
			
			return sb.append(");");
		}

		private StringBuffer generate(String owner, ILoop loop)
		{
			String identifier = helper.retrieveIdentifierName(loop, "METHOD");
			String name = loop.getName();
			if(name == null)
				name = "";
			else
				name = "\"" + name + "\"";
				
			StringBuffer sb = new StringBuffer(hyadesTestSuiteClassName).append(" ").append(identifier);
			sb.append(" = new ").append(hyadesTestSuiteClassName).append("(").append(name).append(");").append(NL);
			sb.append(owner).append(".addTest(new ").append(helper.getImportedName("junit.extensions.RepeatedTest")).append("(").append(identifier).append(", ").append(loop.getCondition().getConstraint()).append("));").append(NL);
			sb.append(identifier).append(".setId(\"").append(loop.getId()).append("\")");
			if(!loop.isSynchronous())
				sb.append(".setSynchronous(false)");				
			sb.append(";");
			
			return sb.append(NL).append(NL).append(generate(identifier, loop.getBlock().getActions()).toString());
		}
	}

    
	helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
	final String hyadesTestSuiteClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestSuite");

    stringBuffer.append(TEXT_2);
    stringBuffer.append(testSuite.getName());
    stringBuffer.append(TEXT_3);
     
		String javaElement = helper.retrieveIdentifierName(testSuite, "SUITE"); 
		String code = new InvocationGenerator(hyadesTestSuiteClassName).generate(javaElement, testSuite.getImplementor().getBlock().getActions()).toString();


    stringBuffer.append(TEXT_4);
    stringBuffer.append(hyadesTestSuiteClassName);
    stringBuffer.append(TEXT_5);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(hyadesTestSuiteClassName);
    stringBuffer.append(TEXT_7);
    stringBuffer.append(testSuite.getName());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_9);
    stringBuffer.append(testSuite.getId());
    stringBuffer.append(TEXT_10);
    stringBuffer.append(TEXT_11);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_12);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_13);
    
    return stringBuffer.toString();
  }
}
