/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenTestSuite.java,v 1.9 2005/04/22 14:51:08 bjiang Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.java.internal.codegen;

import java.util.Iterator;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.internal.codegen.ImportManager;
import org.eclipse.hyades.ui.internal.util.StringUtil;

class GenTestSuite
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "\t\t" + NL;
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";" + NL;
  protected final String TEXT_4 = NL + NL + "/**" + NL + " * Generated code for the test suite <b>";
  protected final String TEXT_5 = "</b> located at" + NL + " * <i>";
  protected final String TEXT_6 = "</i>";
  protected final String TEXT_7 = ".";
  protected final String TEXT_8 = NL + " *" + NL + " * ";
  protected final String TEXT_9 = NL + " */" + NL + "public class ";
  protected final String TEXT_10 = NL + "extends ";
  protected final String TEXT_11 = NL + "{" + NL + "\t/**" + NL + "\t * Constructor for ";
  protected final String TEXT_12 = "." + NL + "\t * @param name" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_13 = "(String name)" + NL + "\t{" + NL + "\t\tsuper(name);" + NL + "\t}" + NL;
  protected final String TEXT_14 = NL + "\t" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#setUp()" + NL + "\t */" + NL + "\tprotected void setUp()" + NL + "\tthrows ";
  protected final String TEXT_15 = NL + "\t{" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#tearDown()" + NL + "\t */" + NL + "\tprotected void tearDown()" + NL + "\tthrows ";
  protected final String TEXT_16 = NL + "\t{" + NL + "\t}\t";
  protected final String TEXT_17 = NL;
  protected final String TEXT_18 = "}";

	public String generate(ITestSuite testSuite, final Helper helper)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	String packageName = helper.getPackageName(testSuite);
	String className = helper.retrieveClassName(testSuite);
	String description = testSuite.getDescription();
	if(description != null)
		description = StringUtil.replace(description.trim(), NL, NL + " * ");
	else
		description = "";
		
	helper.setImportManager(new ImportManager(packageName));
	helper.getImportedName(packageName + "." + className);

    stringBuffer.append(TEXT_2);
    stringBuffer.append(packageName);
    stringBuffer.append(TEXT_3);
    
	helper.addImport("junit.framework.Test");
	helper.addImport("org.eclipse.hyades.test.common.junit.DefaultTestArbiter");
	helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestCase");
	helper.markImportLocation(stringBuffer);

	final String hyadesTestCaseClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestCase");
	String exceptionClassName = helper.getImportedName("java.lang.Exception");
	String filePath = helper.getFilePath(testSuite);

    stringBuffer.append(TEXT_4);
    stringBuffer.append(testSuite.getName());
    if(filePath != null){
    stringBuffer.append(TEXT_5);
    stringBuffer.append(filePath);
    stringBuffer.append(TEXT_6);
    }
    stringBuffer.append(TEXT_7);
    if(description.length() > 0){
    stringBuffer.append(TEXT_8);
    stringBuffer.append(description);
    }
    stringBuffer.append(TEXT_9);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_10);
    stringBuffer.append(hyadesTestCaseClassName);
    stringBuffer.append(TEXT_11);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_12);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_13);
    
	GenSuiteMethod suiteMethodGenerator = new GenSuiteMethod();
	stringBuffer.append(suiteMethodGenerator.generate(testSuite, helper));

    stringBuffer.append(TEXT_14);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_15);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_16);
    
	for(Iterator i=testSuite.getITestCases().iterator(); i.hasNext();)
	{
		ITestCase testCase = (ITestCase)i.next();
		GenTestMethod generator = new GenTestMethod();
		stringBuffer.append(generator.generate(testCase, helper));
	}

    stringBuffer.append(TEXT_17);
    stringBuffer.append(TEXT_18);
    helper.emitSortedImports();
    
    return stringBuffer.toString();
  }
}
