/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLaunchConfigurationValidator.java,v 1.6 2005/02/16 22:21:44 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.codegen.JUnitGenerator;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.ITestLaunchConfigurationValidator;

/**
 * @see ITestLaunchConfigurationValidator
 */
public class TestLaunchConfigurationValidator implements ITestLaunchConfigurationValidator {

	/**
	 * @see ITestLaunchConfigurationValidator#validate
	 */
	public Diagnostic validate(ILaunchConfiguration launchConfiguration, ResourceSet resourceSet)  {
		TPFTest test;
		try {
			test = TestLaunchConfigurationFacade.getTest(launchConfiguration, resourceSet);
		} catch (CoreException e) {
			test = null;
		}
		if (test != null) {
			TPFTestSuite testSuite = null;
			if (test instanceof TPFTestCase) {
				testSuite = ((TPFTestCase)test).getTestSuite();
			} else if (test instanceof TPFTestSuite) {
				testSuite = (TPFTestSuite)test;
			}
			if (testSuite != null) {
				Generator generator = new JUnitGenerator();
				if (!generator.getFileHandle(testSuite).exists()) {
					// The code has not been generated yet. Issue an error
					return new Diagnostic() {
						public String getMessage() {
							return TestJavaPlugin.getString("_ERROR_LAUNCH_VALIDATOR"); //$NON-NLS-1$
						}
						public int getSeverity() {
							return ERROR;
						}
					};
				}
			}
			return null;
		}
		return null;
	}
}
