/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ContextInstanceType.java,v 1.10 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.configuration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Context Instance Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 				A context instance has a set of properties that are
 * 				common to every context when it is running. It also
 * 				contains a variety of components or "processing units"
 * 				including at least 1 sensor which is always needed to
 * 				start the sequence. The components are executed in the
 * 				order they are declared, and this order has to match the
 * 				context configuration file.
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getSensor <em>Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getExtractor <em>Extractor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getParser <em>Parser</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getProcessUnit <em>Process Unit</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getFormatter <em>Formatter</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getFilter <em>Filter</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getOutputter <em>Outputter</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getCharset <em>Charset</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#isContinuousOperation <em>Continuous Operation</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoCountryCode <em>Iso Country Code</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoLanguageCode <em>Iso Language Code</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getMaximumIdleTime <em>Maximum Idle Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getPauseInterval <em>Pause Interval</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getUniqueID <em>Unique ID</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType()
 * @model 
 * @generated
 */
public interface ContextInstanceType extends EObject{
	/**
	 * Returns the value of the '<em><b>Sensor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sensor</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sensor</em>' containment reference.
	 * @see #setSensor(SensorConfigType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Sensor()
	 * @model containment="true" resolveProxies="false" required="true"
	 * @generated
	 */
	SensorConfigType getSensor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getSensor <em>Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sensor</em>' containment reference.
	 * @see #getSensor()
	 * @generated
	 */
	void setSensor(SensorConfigType value);

	/**
	 * Returns the value of the '<em><b>Extractor</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Extractor</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extractor</em>' containment reference.
	 * @see #setExtractor(ExtractorType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Extractor()
	 * @model containment="true" resolveProxies="false"
	 * @generated
	 */
	ExtractorType getExtractor();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getExtractor <em>Extractor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Extractor</em>' containment reference.
	 * @see #getExtractor()
	 * @generated
	 */
	void setExtractor(ExtractorType value);

	/**
	 * Returns the value of the '<em><b>Parser</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parser</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parser</em>' containment reference.
	 * @see #setParser(ParserConfigType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Parser()
	 * @model containment="true" resolveProxies="false"
	 * @generated
	 */
	ParserConfigType getParser();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getParser <em>Parser</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parser</em>' containment reference.
	 * @see #getParser()
	 * @generated
	 */
	void setParser(ParserConfigType value);

	/**
	 * Returns the value of the '<em><b>Process Unit</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Process Unit</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Process Unit</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_ProcessUnit()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType" containment="true" resolveProxies="false"
	 * @generated
	 */
	EList getProcessUnit();

	/**
	 * Returns the value of the '<em><b>Formatter</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Formatter</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Formatter</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Formatter()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType" containment="true" resolveProxies="false"
	 * @generated
	 */
	EList getFormatter();

	/**
	 * Returns the value of the '<em><b>Filter</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Filter</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Filter</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Filter()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType" containment="true" resolveProxies="false"
	 * @generated
	 */
	EList getFilter();

	/**
	 * Returns the value of the '<em><b>Outputter</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Outputter</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Outputter</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Outputter()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType" containment="true" resolveProxies="false"
	 * @generated
	 */
	EList getOutputter();

	/**
	 * Returns the value of the '<em><b>Charset</b></em>' attribute.
	 * The default value is <code>"UTF-8"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Charset</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Charset</em>' attribute.
	 * @see #isSetCharset()
	 * @see #unsetCharset()
	 * @see #setCharset(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Charset()
	 * @model default="UTF-8" unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getCharset();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getCharset <em>Charset</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Charset</em>' attribute.
	 * @see #isSetCharset()
	 * @see #unsetCharset()
	 * @see #getCharset()
	 * @generated
	 */
	void setCharset(String value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getCharset <em>Charset</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetCharset()
	 * @see #getCharset()
	 * @see #setCharset(String)
	 * @generated
	 */
	void unsetCharset();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getCharset <em>Charset</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Charset</em>' attribute is set.
	 * @see #unsetCharset()
	 * @see #getCharset()
	 * @see #setCharset(String)
	 * @generated
	 */
	boolean isSetCharset();

	/**
	 * Returns the value of the '<em><b>Continuous Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					A context has the sole purpose of running it's
	 * 					components. These components are typically used to
	 * 					process input. This processing occurs either only
	 * 					once when started, for a specific length of time, or
	 * 					until an amount of time has passed with no
	 * 					processing to do. To support this a boolean option
	 * 					of continuous operation is provided. True indicates
	 * 					as implied. False indicates how long the context
	 * 					will run with no input, hence idle. A maximum idle
	 * 					time of zero implies a run once symantic. Any other
	 * 					time is a maximum amount of time the context will
	 * 					wait for activity. Once no input has been detected
	 * 					the context will pause before attempting activity
	 * 					again this is determined by the pauseInterval.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Continuous Operation</em>' attribute.
	 * @see #isSetContinuousOperation()
	 * @see #unsetContinuousOperation()
	 * @see #setContinuousOperation(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_ContinuousOperation()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean" required="true"
	 * @generated
	 */
	boolean isContinuousOperation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#isContinuousOperation <em>Continuous Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Continuous Operation</em>' attribute.
	 * @see #isSetContinuousOperation()
	 * @see #unsetContinuousOperation()
	 * @see #isContinuousOperation()
	 * @generated
	 */
	void setContinuousOperation(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#isContinuousOperation <em>Continuous Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetContinuousOperation()
	 * @see #isContinuousOperation()
	 * @see #setContinuousOperation(boolean)
	 * @generated
	 */
	void unsetContinuousOperation();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#isContinuousOperation <em>Continuous Operation</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Continuous Operation</em>' attribute is set.
	 * @see #unsetContinuousOperation()
	 * @see #isContinuousOperation()
	 * @see #setContinuousOperation(boolean)
	 * @generated
	 */
	boolean isSetContinuousOperation();

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_Description()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Iso Country Code</b></em>' attribute.
	 * The default value is <code>"US"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Iso Country Code</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Iso Country Code</em>' attribute.
	 * @see #isSetIsoCountryCode()
	 * @see #unsetIsoCountryCode()
	 * @see #setIsoCountryCode(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_IsoCountryCode()
	 * @model default="US" unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getIsoCountryCode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoCountryCode <em>Iso Country Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Iso Country Code</em>' attribute.
	 * @see #isSetIsoCountryCode()
	 * @see #unsetIsoCountryCode()
	 * @see #getIsoCountryCode()
	 * @generated
	 */
	void setIsoCountryCode(String value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoCountryCode <em>Iso Country Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetIsoCountryCode()
	 * @see #getIsoCountryCode()
	 * @see #setIsoCountryCode(String)
	 * @generated
	 */
	void unsetIsoCountryCode();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoCountryCode <em>Iso Country Code</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Iso Country Code</em>' attribute is set.
	 * @see #unsetIsoCountryCode()
	 * @see #getIsoCountryCode()
	 * @see #setIsoCountryCode(String)
	 * @generated
	 */
	boolean isSetIsoCountryCode();

	/**
	 * Returns the value of the '<em><b>Iso Language Code</b></em>' attribute.
	 * The default value is <code>"en"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Iso Language Code</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Iso Language Code</em>' attribute.
	 * @see #isSetIsoLanguageCode()
	 * @see #unsetIsoLanguageCode()
	 * @see #setIsoLanguageCode(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_IsoLanguageCode()
	 * @model default="en" unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getIsoLanguageCode();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoLanguageCode <em>Iso Language Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Iso Language Code</em>' attribute.
	 * @see #isSetIsoLanguageCode()
	 * @see #unsetIsoLanguageCode()
	 * @see #getIsoLanguageCode()
	 * @generated
	 */
	void setIsoLanguageCode(String value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoLanguageCode <em>Iso Language Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetIsoLanguageCode()
	 * @see #getIsoLanguageCode()
	 * @see #setIsoLanguageCode(String)
	 * @generated
	 */
	void unsetIsoLanguageCode();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getIsoLanguageCode <em>Iso Language Code</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Iso Language Code</em>' attribute is set.
	 * @see #unsetIsoLanguageCode()
	 * @see #getIsoLanguageCode()
	 * @see #setIsoLanguageCode(String)
	 * @generated
	 */
	boolean isSetIsoLanguageCode();

	/**
	 * Returns the value of the '<em><b>Maximum Idle Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Maximum Idle Time</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Maximum Idle Time</em>' attribute.
	 * @see #setMaximumIdleTime(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_MaximumIdleTime()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getMaximumIdleTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getMaximumIdleTime <em>Maximum Idle Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Maximum Idle Time</em>' attribute.
	 * @see #getMaximumIdleTime()
	 * @generated
	 */
	void setMaximumIdleTime(String value);

	/**
	 * Returns the value of the '<em><b>Pause Interval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Pause Interval</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pause Interval</em>' attribute.
	 * @see #setPauseInterval(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_PauseInterval()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getPauseInterval();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getPauseInterval <em>Pause Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pause Interval</em>' attribute.
	 * @see #getPauseInterval()
	 * @generated
	 */
	void setPauseInterval(String value);

	/**
	 * Returns the value of the '<em><b>Unique ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Unique ID</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Unique ID</em>' attribute.
	 * @see #setUniqueID(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage#getContextInstanceType_UniqueID()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getUniqueID();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType#getUniqueID <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unique ID</em>' attribute.
	 * @see #getUniqueID()
	 * @generated
	 */
	void setUniqueID(String value);

} // ContextInstanceType
