/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ContextInstanceTypeImpl.java,v 1.11 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Context Instance Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getSensor <em>Sensor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getExtractor <em>Extractor</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getParser <em>Parser</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getProcessUnit <em>Process Unit</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getFormatter <em>Formatter</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getFilter <em>Filter</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getOutputter <em>Outputter</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getCharset <em>Charset</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#isContinuousOperation <em>Continuous Operation</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getIsoCountryCode <em>Iso Country Code</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getIsoLanguageCode <em>Iso Language Code</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getMaximumIdleTime <em>Maximum Idle Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getPauseInterval <em>Pause Interval</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ContextInstanceTypeImpl#getUniqueID <em>Unique ID</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ContextInstanceTypeImpl extends EObjectImpl implements ContextInstanceType {
	/**
	 * The cached value of the '{@link #getSensor() <em>Sensor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSensor()
	 * @generated
	 * @ordered
	 */
	protected SensorConfigType sensor = null;

	/**
	 * The cached value of the '{@link #getExtractor() <em>Extractor</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtractor()
	 * @generated
	 * @ordered
	 */
	protected ExtractorType extractor = null;

	/**
	 * The cached value of the '{@link #getParser() <em>Parser</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParser()
	 * @generated
	 * @ordered
	 */
	protected ParserConfigType parser = null;

	/**
	 * The cached value of the '{@link #getProcessUnit() <em>Process Unit</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessUnit()
	 * @generated
	 * @ordered
	 */
	protected EList processUnit = null;

	/**
	 * The cached value of the '{@link #getFormatter() <em>Formatter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormatter()
	 * @generated
	 * @ordered
	 */
	protected EList formatter = null;

	/**
	 * The cached value of the '{@link #getFilter() <em>Filter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFilter()
	 * @generated
	 * @ordered
	 */
	protected EList filter = null;

	/**
	 * The cached value of the '{@link #getOutputter() <em>Outputter</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputter()
	 * @generated
	 * @ordered
	 */
	protected EList outputter = null;

	/**
	 * The default value of the '{@link #getCharset() <em>Charset</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCharset()
	 * @generated
	 * @ordered
	 */
	protected static final String CHARSET_EDEFAULT = "UTF-8";

	/**
	 * The cached value of the '{@link #getCharset() <em>Charset</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCharset()
	 * @generated
	 * @ordered
	 */
	protected String charset = CHARSET_EDEFAULT;

	/**
	 * This is true if the Charset attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean charsetESet = false;

	/**
	 * The default value of the '{@link #isContinuousOperation() <em>Continuous Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isContinuousOperation()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CONTINUOUS_OPERATION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isContinuousOperation() <em>Continuous Operation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isContinuousOperation()
	 * @generated
	 * @ordered
	 */
	protected boolean continuousOperation = CONTINUOUS_OPERATION_EDEFAULT;

	/**
	 * This is true if the Continuous Operation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean continuousOperationESet = false;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getIsoCountryCode() <em>Iso Country Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsoCountryCode()
	 * @generated
	 * @ordered
	 */
	protected static final String ISO_COUNTRY_CODE_EDEFAULT = "US";

	/**
	 * The cached value of the '{@link #getIsoCountryCode() <em>Iso Country Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsoCountryCode()
	 * @generated
	 * @ordered
	 */
	protected String isoCountryCode = ISO_COUNTRY_CODE_EDEFAULT;

	/**
	 * This is true if the Iso Country Code attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean isoCountryCodeESet = false;

	/**
	 * The default value of the '{@link #getIsoLanguageCode() <em>Iso Language Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsoLanguageCode()
	 * @generated
	 * @ordered
	 */
	protected static final String ISO_LANGUAGE_CODE_EDEFAULT = "en";

	/**
	 * The cached value of the '{@link #getIsoLanguageCode() <em>Iso Language Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsoLanguageCode()
	 * @generated
	 * @ordered
	 */
	protected String isoLanguageCode = ISO_LANGUAGE_CODE_EDEFAULT;

	/**
	 * This is true if the Iso Language Code attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean isoLanguageCodeESet = false;

	/**
	 * The default value of the '{@link #getMaximumIdleTime() <em>Maximum Idle Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumIdleTime()
	 * @generated
	 * @ordered
	 */
	protected static final String MAXIMUM_IDLE_TIME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMaximumIdleTime() <em>Maximum Idle Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumIdleTime()
	 * @generated
	 * @ordered
	 */
	protected String maximumIdleTime = MAXIMUM_IDLE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getPauseInterval() <em>Pause Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPauseInterval()
	 * @generated
	 * @ordered
	 */
	protected static final String PAUSE_INTERVAL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPauseInterval() <em>Pause Interval</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPauseInterval()
	 * @generated
	 * @ordered
	 */
	protected String pauseInterval = PAUSE_INTERVAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIQUE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected String uniqueID = UNIQUE_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected ContextInstanceTypeImpl() {
		super();
		uniqueID = (new Guid()).toString();		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ConfigurationPackage.eINSTANCE.getContextInstanceType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorConfigType getSensor() {
		return sensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSensor(SensorConfigType newSensor, NotificationChain msgs) {
		SensorConfigType oldSensor = sensor;
		sensor = newSensor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR, oldSensor, newSensor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSensor(SensorConfigType newSensor) {
		if (newSensor != sensor) {
			NotificationChain msgs = null;
			if (sensor != null)
				msgs = ((InternalEObject)sensor).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR, null, msgs);
			if (newSensor != null)
				msgs = ((InternalEObject)newSensor).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR, null, msgs);
			msgs = basicSetSensor(newSensor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR, newSensor, newSensor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtractorType getExtractor() {
		return extractor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetExtractor(ExtractorType newExtractor, NotificationChain msgs) {
		ExtractorType oldExtractor = extractor;
		extractor = newExtractor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR, oldExtractor, newExtractor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtractor(ExtractorType newExtractor) {
		if (newExtractor != extractor) {
			NotificationChain msgs = null;
			if (extractor != null)
				msgs = ((InternalEObject)extractor).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR, null, msgs);
			if (newExtractor != null)
				msgs = ((InternalEObject)newExtractor).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR, null, msgs);
			msgs = basicSetExtractor(newExtractor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR, newExtractor, newExtractor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParserConfigType getParser() {
		return parser;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParser(ParserConfigType newParser, NotificationChain msgs) {
		ParserConfigType oldParser = parser;
		parser = newParser;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER, oldParser, newParser);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParser(ParserConfigType newParser) {
		if (newParser != parser) {
			NotificationChain msgs = null;
			if (parser != null)
				msgs = ((InternalEObject)parser).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER, null, msgs);
			if (newParser != null)
				msgs = ((InternalEObject)newParser).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER, null, msgs);
			msgs = basicSetParser(newParser, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER, newParser, newParser));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getProcessUnit() {
		if (processUnit == null) {
			processUnit = new EObjectContainmentEList(ProcessUnitType.class, this, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT);
		}
		return processUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFormatter() {
		if (formatter == null) {
			formatter = new EObjectContainmentEList(FormatterType.class, this, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER);
		}
		return formatter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFilter() {
		if (filter == null) {
			filter = new EObjectContainmentEList(FilterConfigType.class, this, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FILTER);
		}
		return filter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOutputter() {
		if (outputter == null) {
			outputter = new EObjectContainmentEList(OutputterConfigType.class, this, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER);
		}
		return outputter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCharset(String newCharset) {
		String oldCharset = charset;
		charset = newCharset;
		boolean oldCharsetESet = charsetESet;
		charsetESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET, oldCharset, charset, !oldCharsetESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetCharset() {
		String oldCharset = charset;
		boolean oldCharsetESet = charsetESet;
		charset = CHARSET_EDEFAULT;
		charsetESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET, oldCharset, CHARSET_EDEFAULT, oldCharsetESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetCharset() {
		return charsetESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isContinuousOperation() {
		return continuousOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContinuousOperation(boolean newContinuousOperation) {
		boolean oldContinuousOperation = continuousOperation;
		continuousOperation = newContinuousOperation;
		boolean oldContinuousOperationESet = continuousOperationESet;
		continuousOperationESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION, oldContinuousOperation, continuousOperation, !oldContinuousOperationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetContinuousOperation() {
		boolean oldContinuousOperation = continuousOperation;
		boolean oldContinuousOperationESet = continuousOperationESet;
		continuousOperation = CONTINUOUS_OPERATION_EDEFAULT;
		continuousOperationESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION, oldContinuousOperation, CONTINUOUS_OPERATION_EDEFAULT, oldContinuousOperationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetContinuousOperation() {
		return continuousOperationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIsoCountryCode() {
		return isoCountryCode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsoCountryCode(String newIsoCountryCode) {
		String oldIsoCountryCode = isoCountryCode;
		isoCountryCode = newIsoCountryCode;
		boolean oldIsoCountryCodeESet = isoCountryCodeESet;
		isoCountryCodeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE, oldIsoCountryCode, isoCountryCode, !oldIsoCountryCodeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetIsoCountryCode() {
		String oldIsoCountryCode = isoCountryCode;
		boolean oldIsoCountryCodeESet = isoCountryCodeESet;
		isoCountryCode = ISO_COUNTRY_CODE_EDEFAULT;
		isoCountryCodeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE, oldIsoCountryCode, ISO_COUNTRY_CODE_EDEFAULT, oldIsoCountryCodeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetIsoCountryCode() {
		return isoCountryCodeESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIsoLanguageCode() {
		return isoLanguageCode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsoLanguageCode(String newIsoLanguageCode) {
		String oldIsoLanguageCode = isoLanguageCode;
		isoLanguageCode = newIsoLanguageCode;
		boolean oldIsoLanguageCodeESet = isoLanguageCodeESet;
		isoLanguageCodeESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE, oldIsoLanguageCode, isoLanguageCode, !oldIsoLanguageCodeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetIsoLanguageCode() {
		String oldIsoLanguageCode = isoLanguageCode;
		boolean oldIsoLanguageCodeESet = isoLanguageCodeESet;
		isoLanguageCode = ISO_LANGUAGE_CODE_EDEFAULT;
		isoLanguageCodeESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE, oldIsoLanguageCode, ISO_LANGUAGE_CODE_EDEFAULT, oldIsoLanguageCodeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetIsoLanguageCode() {
		return isoLanguageCodeESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMaximumIdleTime() {
		return maximumIdleTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaximumIdleTime(String newMaximumIdleTime) {
		String oldMaximumIdleTime = maximumIdleTime;
		maximumIdleTime = newMaximumIdleTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME, oldMaximumIdleTime, maximumIdleTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPauseInterval() {
		return pauseInterval;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPauseInterval(String newPauseInterval) {
		String oldPauseInterval = pauseInterval;
		pauseInterval = newPauseInterval;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL, oldPauseInterval, pauseInterval));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUniqueID() {
		return uniqueID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUniqueID(String newUniqueID) {
		String oldUniqueID = uniqueID;
		uniqueID = newUniqueID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID, oldUniqueID, uniqueID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
					return basicSetSensor(null, msgs);
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
					return basicSetExtractor(null, msgs);
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
					return basicSetParser(null, msgs);
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
					return ((InternalEList)getProcessUnit()).basicRemove(otherEnd, msgs);
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
					return ((InternalEList)getFormatter()).basicRemove(otherEnd, msgs);
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FILTER:
					return ((InternalEList)getFilter()).basicRemove(otherEnd, msgs);
				case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER:
					return ((InternalEList)getOutputter()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
				return getSensor();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
				return getExtractor();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
				return getParser();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
				return getProcessUnit();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
				return getFormatter();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FILTER:
				return getFilter();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER:
				return getOutputter();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET:
				return getCharset();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
				return isContinuousOperation() ? Boolean.TRUE : Boolean.FALSE;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
				return getDescription();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE:
				return getIsoCountryCode();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE:
				return getIsoLanguageCode();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
				return getMaximumIdleTime();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
				return getPauseInterval();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
				return getUniqueID();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
				setSensor((SensorConfigType)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
				setExtractor((ExtractorType)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
				setParser((ParserConfigType)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
				getProcessUnit().clear();
				getProcessUnit().addAll((Collection)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
				getFormatter().clear();
				getFormatter().addAll((Collection)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FILTER:
				getFilter().clear();
				getFilter().addAll((Collection)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER:
				getOutputter().clear();
				getOutputter().addAll((Collection)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET:
				setCharset((String)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
				setContinuousOperation(((Boolean)newValue).booleanValue());
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE:
				setIsoCountryCode((String)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE:
				setIsoLanguageCode((String)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
				setMaximumIdleTime((String)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
				setPauseInterval((String)newValue);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
				setSensor((SensorConfigType)null);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
				setExtractor((ExtractorType)null);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
				setParser((ParserConfigType)null);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
				getProcessUnit().clear();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
				getFormatter().clear();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FILTER:
				getFilter().clear();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER:
				getOutputter().clear();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET:
				unsetCharset();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
				unsetContinuousOperation();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE:
				unsetIsoCountryCode();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE:
				unsetIsoLanguageCode();
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
				setMaximumIdleTime(MAXIMUM_IDLE_TIME_EDEFAULT);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
				setPauseInterval(PAUSE_INTERVAL_EDEFAULT);
				return;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__SENSOR:
				return sensor != null;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__EXTRACTOR:
				return extractor != null;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PARSER:
				return parser != null;
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PROCESS_UNIT:
				return processUnit != null && !processUnit.isEmpty();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FORMATTER:
				return formatter != null && !formatter.isEmpty();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__FILTER:
				return filter != null && !filter.isEmpty();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__OUTPUTTER:
				return outputter != null && !outputter.isEmpty();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CHARSET:
				return isSetCharset();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__CONTINUOUS_OPERATION:
				return isSetContinuousOperation();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_COUNTRY_CODE:
				return isSetIsoCountryCode();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__ISO_LANGUAGE_CODE:
				return isSetIsoLanguageCode();
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__MAXIMUM_IDLE_TIME:
				return MAXIMUM_IDLE_TIME_EDEFAULT == null ? maximumIdleTime != null : !MAXIMUM_IDLE_TIME_EDEFAULT.equals(maximumIdleTime);
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__PAUSE_INTERVAL:
				return PAUSE_INTERVAL_EDEFAULT == null ? pauseInterval != null : !PAUSE_INTERVAL_EDEFAULT.equals(pauseInterval);
			case ConfigurationPackage.CONTEXT_INSTANCE_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (charset: ");
		if (charsetESet) result.append(charset); else result.append("<unset>");
		result.append(", continuousOperation: ");
		if (continuousOperationESet) result.append(continuousOperation); else result.append("<unset>");
		result.append(", description: ");
		result.append(description);
		result.append(", isoCountryCode: ");
		if (isoCountryCodeESet) result.append(isoCountryCode); else result.append("<unset>");
		result.append(", isoLanguageCode: ");
		if (isoLanguageCodeESet) result.append(isoLanguageCode); else result.append("<unset>");
		result.append(", maximumIdleTime: ");
		result.append(maximumIdleTime);
		result.append(", pauseInterval: ");
		result.append(pauseInterval);
		result.append(", uniqueID: ");
		result.append(uniqueID);
		result.append(')');
		return result.toString();
	}

} //ContextInstanceTypeImpl
