/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ExtractorType.java,v 1.9 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.extractor;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 				An extractor has the role of given the input array of
 * 				for example strings to create a structure that hold
 * 				exactly one complete message. An extractor actually
 * 				returns an array of these structured objects.
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isContainsLineBreaks <em>Contains Line Breaks</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getEndPattern <em>End Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeEndPattern <em>Include End Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeStartPattern <em>Include Start Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getLineBreakSymbol <em>Line Break Symbol</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isReplaceLineBreaks <em>Replace Line Breaks</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getStartPattern <em>Start Pattern</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getUniqueID <em>Unique ID</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType()
 * @model 
 * @generated
 */
public interface ExtractorType extends EObject{
	/**
	 * Returns the value of the '<em><b>Contains Line Breaks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					If a message can contain or more precisely span
	 * 					multiple lines of an input file which would
	 * 					typically mean spans Objects in the input array then
	 * 					this attribute would be set to true.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Contains Line Breaks</em>' attribute.
	 * @see #isSetContainsLineBreaks()
	 * @see #unsetContainsLineBreaks()
	 * @see #setContainsLineBreaks(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_ContainsLineBreaks()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean" required="true"
	 * @generated
	 */
	boolean isContainsLineBreaks();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isContainsLineBreaks <em>Contains Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Contains Line Breaks</em>' attribute.
	 * @see #isSetContainsLineBreaks()
	 * @see #unsetContainsLineBreaks()
	 * @see #isContainsLineBreaks()
	 * @generated
	 */
	void setContainsLineBreaks(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isContainsLineBreaks <em>Contains Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetContainsLineBreaks()
	 * @see #isContainsLineBreaks()
	 * @see #setContainsLineBreaks(boolean)
	 * @generated
	 */
	void unsetContainsLineBreaks();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isContainsLineBreaks <em>Contains Line Breaks</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Contains Line Breaks</em>' attribute is set.
	 * @see #unsetContainsLineBreaks()
	 * @see #isContainsLineBreaks()
	 * @see #setContainsLineBreaks(boolean)
	 * @generated
	 */
	boolean isSetContainsLineBreaks();

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					A textual description of this extractor
	 * 					configuration.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_Description()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>End Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					This string defines the expression used by the
	 * 					extractor to identify the ending of a message.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>End Pattern</em>' attribute.
	 * @see #setEndPattern(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_EndPattern()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getEndPattern();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getEndPattern <em>End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>End Pattern</em>' attribute.
	 * @see #getEndPattern()
	 * @generated
	 */
	void setEndPattern(String value);

	/**
	 * Returns the value of the '<em><b>Include End Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					Define if the matched ending string should be
	 * 					included in the resulting message string.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Include End Pattern</em>' attribute.
	 * @see #isSetIncludeEndPattern()
	 * @see #unsetIncludeEndPattern()
	 * @see #setIncludeEndPattern(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_IncludeEndPattern()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean" required="true"
	 * @generated
	 */
	boolean isIncludeEndPattern();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeEndPattern <em>Include End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Include End Pattern</em>' attribute.
	 * @see #isSetIncludeEndPattern()
	 * @see #unsetIncludeEndPattern()
	 * @see #isIncludeEndPattern()
	 * @generated
	 */
	void setIncludeEndPattern(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeEndPattern <em>Include End Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetIncludeEndPattern()
	 * @see #isIncludeEndPattern()
	 * @see #setIncludeEndPattern(boolean)
	 * @generated
	 */
	void unsetIncludeEndPattern();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeEndPattern <em>Include End Pattern</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Include End Pattern</em>' attribute is set.
	 * @see #unsetIncludeEndPattern()
	 * @see #isIncludeEndPattern()
	 * @see #setIncludeEndPattern(boolean)
	 * @generated
	 */
	boolean isSetIncludeEndPattern();

	/**
	 * Returns the value of the '<em><b>Include Start Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					Define if the matched starting string should be
	 * 					included in the resulting message string.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Include Start Pattern</em>' attribute.
	 * @see #isSetIncludeStartPattern()
	 * @see #unsetIncludeStartPattern()
	 * @see #setIncludeStartPattern(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_IncludeStartPattern()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean" required="true"
	 * @generated
	 */
	boolean isIncludeStartPattern();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeStartPattern <em>Include Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Include Start Pattern</em>' attribute.
	 * @see #isSetIncludeStartPattern()
	 * @see #unsetIncludeStartPattern()
	 * @see #isIncludeStartPattern()
	 * @generated
	 */
	void setIncludeStartPattern(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeStartPattern <em>Include Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetIncludeStartPattern()
	 * @see #isIncludeStartPattern()
	 * @see #setIncludeStartPattern(boolean)
	 * @generated
	 */
	void unsetIncludeStartPattern();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isIncludeStartPattern <em>Include Start Pattern</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Include Start Pattern</em>' attribute is set.
	 * @see #unsetIncludeStartPattern()
	 * @see #isIncludeStartPattern()
	 * @see #setIncludeStartPattern(boolean)
	 * @generated
	 */
	boolean isSetIncludeStartPattern();

	/**
	 * Returns the value of the '<em><b>Line Break Symbol</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					If a message spans multiple lines of an input file,
	 * 					those lines are concatenated into one line. In cases
	 * 					where preserving the line boundary is needed, a
	 * 					substitution string can be defined by providing a
	 * 					value for this attribute.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Line Break Symbol</em>' attribute.
	 * @see #setLineBreakSymbol(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_LineBreakSymbol()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getLineBreakSymbol();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getLineBreakSymbol <em>Line Break Symbol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Line Break Symbol</em>' attribute.
	 * @see #getLineBreakSymbol()
	 * @generated
	 */
	void setLineBreakSymbol(String value);

	/**
	 * Returns the value of the '<em><b>Replace Line Breaks</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					If a message contains line breaks, sometimes it is desireable 
	 * 					to leave them in and sometimes replace them with an alternate
	 * 					string. This can be achieved by setting this attribute to
	 * 					false or true respectively. In the case where they should simply
	 * 					be removed set this attribute to true and the repalcement string
	 * 					to "". 
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Replace Line Breaks</em>' attribute.
	 * @see #isSetReplaceLineBreaks()
	 * @see #unsetReplaceLineBreaks()
	 * @see #setReplaceLineBreaks(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_ReplaceLineBreaks()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean" required="true"
	 * @generated
	 */
	boolean isReplaceLineBreaks();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isReplaceLineBreaks <em>Replace Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Replace Line Breaks</em>' attribute.
	 * @see #isSetReplaceLineBreaks()
	 * @see #unsetReplaceLineBreaks()
	 * @see #isReplaceLineBreaks()
	 * @generated
	 */
	void setReplaceLineBreaks(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isReplaceLineBreaks <em>Replace Line Breaks</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetReplaceLineBreaks()
	 * @see #isReplaceLineBreaks()
	 * @see #setReplaceLineBreaks(boolean)
	 * @generated
	 */
	void unsetReplaceLineBreaks();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#isReplaceLineBreaks <em>Replace Line Breaks</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Replace Line Breaks</em>' attribute is set.
	 * @see #unsetReplaceLineBreaks()
	 * @see #isReplaceLineBreaks()
	 * @see #setReplaceLineBreaks(boolean)
	 * @generated
	 */
	boolean isSetReplaceLineBreaks();

	/**
	 * Returns the value of the '<em><b>Start Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					This string defines the expression used by the
	 * 					extractor to identify the beginning of a message.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Pattern</em>' attribute.
	 * @see #setStartPattern(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_StartPattern()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getStartPattern();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getStartPattern <em>Start Pattern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Pattern</em>' attribute.
	 * @see #getStartPattern()
	 * @generated
	 */
	void setStartPattern(String value);

	/**
	 * Returns the value of the '<em><b>Unique ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					As with all other components a unique identifier is
	 * 					required to associate this configuration to the
	 * 					component defined in the context configuration.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Unique ID</em>' attribute.
	 * @see #setUniqueID(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage#getExtractorType_UniqueID()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getUniqueID();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType#getUniqueID <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Unique ID</em>' attribute.
	 * @see #getUniqueID()
	 * @generated
	 */
	void setUniqueID(String value);

} // ExtractorType
