/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: AbstractFilterRuleType.java,v 1.2 2005/03/24 21:12:26 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Abstract Filter Rule Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * AbstractFilterRuleType gives an abstract definition for a filter rule. Rules are defined for a particular attribute relative to a particular value for that attribute.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeName <em>Attribute Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeNamePath <em>Attribute Name Path</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeValue <em>Attribute Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getImplementationClass <em>Implementation Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#isNegation <em>Negation</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getAbstractFilterRuleType()
 * @model abstract="true"
 * @generated
 */
public interface AbstractFilterRuleType extends EObject {
	/**
	 * Returns the value of the '<em><b>Attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attribute Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attribute Name</em>' attribute.
	 * @see #setAttributeName(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getAbstractFilterRuleType_AttributeName()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getAttributeName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeName <em>Attribute Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Attribute Name</em>' attribute.
	 * @see #getAttributeName()
	 * @generated
	 */
	void setAttributeName(String value);

	/**
	 * Returns the value of the '<em><b>Attribute Name Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attribute Name Path</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attribute Name Path</em>' containment reference.
	 * @see #setAttributeNamePath(PathExpressionType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getAbstractFilterRuleType_AttributeNamePath()
	 * @model containment="true" resolveProxies="false"
	 * @generated
	 */
	PathExpressionType getAttributeNamePath();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeNamePath <em>Attribute Name Path</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Attribute Name Path</em>' containment reference.
	 * @see #getAttributeNamePath()
	 * @generated
	 */
	void setAttributeNamePath(PathExpressionType value);

	/**
	 * Returns the value of the '<em><b>Attribute Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attribute Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Attribute Value</em>' attribute.
	 * @see #setAttributeValue(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getAbstractFilterRuleType_AttributeValue()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getAttributeValue();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeValue <em>Attribute Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Attribute Value</em>' attribute.
	 * @see #getAttributeValue()
	 * @generated
	 */
	void setAttributeValue(String value);

	/**
	 * Returns the value of the '<em><b>Implementation Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Implementation Class</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Implementation Class</em>' attribute.
	 * @see #setImplementationClass(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getAbstractFilterRuleType_ImplementationClass()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getImplementationClass();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getImplementationClass <em>Implementation Class</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Implementation Class</em>' attribute.
	 * @see #getImplementationClass()
	 * @generated
	 */
	void setImplementationClass(String value);

	/**
	 * Returns the value of the '<em><b>Negation</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Negation</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Negation</em>' attribute.
	 * @see #isSetNegation()
	 * @see #unsetNegation()
	 * @see #setNegation(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getAbstractFilterRuleType_Negation()
	 * @model default="false" unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 * @generated
	 */
	boolean isNegation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#isNegation <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Negation</em>' attribute.
	 * @see #isSetNegation()
	 * @see #unsetNegation()
	 * @see #isNegation()
	 * @generated
	 */
	void setNegation(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#isNegation <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetNegation()
	 * @see #isNegation()
	 * @see #setNegation(boolean)
	 * @generated
	 */
	void unsetNegation();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#isNegation <em>Negation</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Negation</em>' attribute is set.
	 * @see #unsetNegation()
	 * @see #isNegation()
	 * @see #setNegation(boolean)
	 * @generated
	 */
	boolean isSetNegation();

} // AbstractFilterRuleType
